/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.tree;

import android.graphics.Canvas;
import android.graphics.Paint;
import de.blox.graphview.Algorithm;
import de.blox.graphview.EdgeRenderer;
import de.blox.graphview.Graph;
import de.blox.graphview.Node;
import de.blox.graphview.Vector;
import de.blox.graphview.tree.BuchheimWalkerConfiguration;
import de.blox.graphview.tree.BuchheimWalkerNodeData;
import de.blox.graphview.tree.TreeEdgeRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuchheimWalkerAlgorithm
implements Algorithm {
    private BuchheimWalkerConfiguration configuration;
    private Map<Node, BuchheimWalkerNodeData> mNodeData = new HashMap<Node, BuchheimWalkerNodeData>();
    private EdgeRenderer edgeRenderer;
    private int minNodeHeight = Integer.MAX_VALUE;
    private int width;

    public BuchheimWalkerAlgorithm(BuchheimWalkerConfiguration configuration) {
        this.configuration = configuration;
        this.edgeRenderer = new TreeEdgeRenderer(configuration.getLevelSeparation());
    }

    public BuchheimWalkerAlgorithm() {
        this(new BuchheimWalkerConfiguration());
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private BuchheimWalkerNodeData createNodeData(Node node) {
        BuchheimWalkerNodeData nodeData = new BuchheimWalkerNodeData();
        nodeData.setAncestor(node);
        this.mNodeData.put(node, nodeData);
        return nodeData;
    }

    private BuchheimWalkerNodeData getNodeData(Node node) {
        return this.mNodeData.get(node);
    }

    private void firstWalk(Graph graph, Node node, int depth, int number) {
        BuchheimWalkerNodeData nodeData = this.createNodeData(node);
        nodeData.setDepth(depth);
        nodeData.setNumber(number);
        this.minNodeHeight = Math.min(this.minNodeHeight, node.getHeight());
        if (this.isLeaf(graph, node)) {
            if (this.hasLeftSibling(graph, node)) {
                Node leftSibling = this.getLeftSibling(graph, node);
                nodeData.setPrelim(this.getPrelim(leftSibling) + (double)this.getSpacing(graph, leftSibling, node));
            }
        } else {
            Node leftMost = this.getLeftMostChild(graph, node);
            Node rightMost = this.getRightMostChild(graph, node);
            Node defaultAncestor = leftMost;
            Node next = leftMost;
            int i = 1;
            while (next != null) {
                this.firstWalk(graph, next, depth + 1, i++);
                defaultAncestor = this.apportion(graph, next, defaultAncestor);
                next = this.getRightSibling(graph, next);
            }
            this.executeShifts(graph, node);
            double midPoint = 0.5 * (this.getPrelim(leftMost) + this.getPrelim(rightMost) + (double)rightMost.getWidth() - (double)node.getWidth());
            if (this.hasLeftSibling(graph, node)) {
                Node leftSibling = this.getLeftSibling(graph, node);
                nodeData.setPrelim(this.getPrelim(leftSibling) + (double)this.getSpacing(graph, leftSibling, node));
                nodeData.setModifier(nodeData.getPrelim() - midPoint);
            } else {
                nodeData.setPrelim(midPoint);
            }
        }
    }

    private void secondWalk(Graph graph, Node node, double modifier) {
        BuchheimWalkerNodeData nodeData = this.getNodeData(node);
        int depth = nodeData.getDepth();
        int firstNodeWidth = graph.getNode(0).getWidth();
        node.setPos(new Vector(nodeData.getPrelim() + modifier + (double)(this.width / 2) - (double)(firstNodeWidth / 2), depth));
        for (Node w : graph.findSuccessors(node)) {
            this.secondWalk(graph, w, modifier + nodeData.getModifier());
        }
    }

    private void executeShifts(Graph graph, Node node) {
        double shift = 0.0;
        double change = 0.0;
        Node w = this.getRightMostChild(graph, node);
        while (w != null) {
            BuchheimWalkerNodeData nodeData = this.getNodeData(w);
            nodeData.setPrelim(nodeData.getPrelim() + shift);
            nodeData.setModifier(nodeData.getModifier() + shift);
            shift += nodeData.getShift() + (change += nodeData.getChange());
            w = this.getLeftSibling(graph, w);
        }
    }

    private Node apportion(Graph graph, Node node, Node defaultAncestor) {
        if (this.hasLeftSibling(graph, node)) {
            Node leftSibling = this.getLeftSibling(graph, node);
            Node vip = node;
            Node vop = node;
            Node vim = leftSibling;
            Node vom = this.getLeftMostChild(graph, graph.findPredecessors(vip).get(0));
            double sip = this.getModifier(vip);
            double sop = this.getModifier(vop);
            double sim = this.getModifier(vim);
            double som = this.getModifier(vom);
            Node nextRight = this.nextRight(graph, vim);
            Node nextLeft = this.nextLeft(graph, vip);
            while (nextRight != null && nextLeft != null) {
                vim = nextRight;
                vip = nextLeft;
                vom = this.nextLeft(graph, vom);
                vop = this.nextRight(graph, vop);
                this.setAncestor(vop, node);
                double shift = this.getPrelim(vim) + sim - (this.getPrelim(vip) + sip) + (double)this.getSpacing(graph, vim, node);
                if (shift > 0.0) {
                    this.moveSubtree(this.ancestor(graph, vim, node, defaultAncestor), node, shift);
                    sip += shift;
                    sop += shift;
                }
                sim += this.getModifier(vim);
                sip += this.getModifier(vip);
                som += this.getModifier(vom);
                sop += this.getModifier(vop);
                nextRight = this.nextRight(graph, vim);
                nextLeft = this.nextLeft(graph, vip);
            }
            if (nextRight != null && this.nextRight(graph, vop) == null) {
                this.setThread(vop, nextRight);
                this.setModifier(vop, this.getModifier(vop) + sim - sop);
            }
            if (nextLeft != null && this.nextLeft(graph, vom) == null) {
                this.setThread(vom, nextLeft);
                this.setModifier(vom, this.getModifier(vom) + sip - som);
                defaultAncestor = node;
            }
        }
        return defaultAncestor;
    }

    private void setAncestor(Node v, Node ancestor) {
        this.getNodeData(v).setAncestor(ancestor);
    }

    private void setModifier(Node v, double modifier) {
        this.getNodeData(v).setModifier(modifier);
    }

    private void setThread(Node v, Node thread) {
        this.getNodeData(v).setThread(thread);
    }

    private double getPrelim(Node v) {
        return this.getNodeData(v).getPrelim();
    }

    private double getModifier(Node vip) {
        return this.getNodeData(vip).getModifier();
    }

    private void moveSubtree(Node wm, Node wp, double shift) {
        BuchheimWalkerNodeData wpNodeData = this.getNodeData(wp);
        BuchheimWalkerNodeData wmNodeData = this.getNodeData(wm);
        int subtrees = wpNodeData.getNumber() - wmNodeData.getNumber();
        wpNodeData.setChange(wpNodeData.getChange() - shift / (double)subtrees);
        wpNodeData.setShift(wpNodeData.getShift() + shift);
        wmNodeData.setChange(wmNodeData.getChange() + shift / (double)subtrees);
        wpNodeData.setPrelim(wpNodeData.getPrelim() + shift);
        wpNodeData.setModifier(wpNodeData.getModifier() + shift);
    }

    private Node ancestor(Graph graph, Node vim, Node node, Node defaultAncestor) {
        BuchheimWalkerNodeData vipNodeData = this.getNodeData(vim);
        if (graph.findPredecessors(vipNodeData.getAncestor()).get(0) == graph.findPredecessors(node).get(0)) {
            return vipNodeData.getAncestor();
        }
        return defaultAncestor;
    }

    private Node nextRight(Graph graph, Node node) {
        if (graph.hasSuccessor(node)) {
            return this.getRightMostChild(graph, node);
        }
        return this.getNodeData(node).getThread();
    }

    private Node nextLeft(Graph graph, Node node) {
        if (graph.hasSuccessor(node)) {
            return this.getLeftMostChild(graph, node);
        }
        return this.getNodeData(node).getThread();
    }

    private int getSpacing(Graph graph, Node leftNode, Node rightNode) {
        int separation = this.configuration.getSubtreeSeparation();
        if (this.isSibling(graph, leftNode, rightNode)) {
            separation = this.configuration.getSiblingSeparation();
        }
        return separation + leftNode.getWidth();
    }

    private boolean isSibling(Graph graph, Node leftNode, Node rightNode) {
        Node leftParent = graph.findPredecessors(leftNode).get(0);
        return graph.findSuccessors(leftParent).contains(rightNode);
    }

    private boolean isLeaf(Graph graph, Node node) {
        return graph.findSuccessors(node).isEmpty();
    }

    private Node getLeftSibling(Graph graph, Node node) {
        if (!this.hasLeftSibling(graph, node)) {
            return null;
        }
        Node parent = graph.findPredecessors(node).get(0);
        List<Node> children = graph.findSuccessors(parent);
        int nodeIndex = children.indexOf(node);
        return children.get(nodeIndex - 1);
    }

    private boolean hasLeftSibling(Graph graph, Node node) {
        List<Node> parents = graph.findPredecessors(node);
        if (parents.isEmpty()) {
            return false;
        }
        Node parent = parents.get(0);
        int nodeIndex = graph.findSuccessors(parent).indexOf(node);
        return nodeIndex > 0;
    }

    private Node getRightSibling(Graph graph, Node node) {
        if (!this.hasRightSibling(graph, node)) {
            return null;
        }
        Node parent = graph.findPredecessors(node).get(0);
        List<Node> children = graph.findSuccessors(parent);
        int nodeIndex = children.indexOf(node);
        return children.get(nodeIndex + 1);
    }

    private boolean hasRightSibling(Graph graph, Node node) {
        List<Node> parents = graph.findPredecessors(node);
        if (parents.isEmpty()) {
            return false;
        }
        Node parent = parents.get(0);
        List<Node> children = graph.findSuccessors(parent);
        int nodeIndex = children.indexOf(node);
        return nodeIndex < children.size() - 1;
    }

    private Node getLeftMostChild(Graph graph, Node node) {
        return graph.findSuccessors(node).get(0);
    }

    private Node getRightMostChild(Graph graph, Node node) {
        List<Node> children = graph.findSuccessors(node);
        if (children.isEmpty()) {
            return null;
        }
        return children.get(children.size() - 1);
    }

    @Override
    public void run(Graph graph) {
        this.mNodeData.clear();
        Node firstNode = graph.getNode(0);
        this.firstWalk(graph, firstNode, 0, 0);
        this.secondWalk(graph, firstNode, -this.getPrelim(firstNode));
        this.positionNodes(graph);
    }

    private void positionNodes(Graph graph) {
        int globalPadding = 0;
        int localPadding = 0;
        int currentLevel = 0;
        for (Node node : this.sortByLevel(graph)) {
            int depth;
            int height = node.getHeight();
            if (height > this.minNodeHeight) {
                localPadding = Math.max(localPadding, height - this.minNodeHeight);
            }
            if ((depth = this.getNodeData(node).getDepth()) != currentLevel) {
                globalPadding += localPadding;
                localPadding = 0;
                currentLevel = depth;
            }
            node.setPos(new Vector(node.getX(), node.getY() * (double)this.minNodeHeight + (double)(depth * this.configuration.getLevelSeparation()) + (double)globalPadding));
        }
    }

    private List<Node> sortByLevel(Graph graph) {
        ArrayList<Node> nodes = new ArrayList<Node>(graph.getNodes());
        Collections.sort(nodes, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                BuchheimWalkerNodeData data1 = BuchheimWalkerAlgorithm.this.getNodeData(o1);
                BuchheimWalkerNodeData data2 = BuchheimWalkerAlgorithm.this.getNodeData(o2);
                return BuchheimWalkerAlgorithm.compare(data1.getDepth(), data2.getDepth());
            }
        });
        return nodes;
    }

    @Override
    public void drawEdges(Canvas canvas, Graph graph, Paint linePaint) {
        this.edgeRenderer.render(canvas, graph, linePaint);
    }

    @Override
    public void setMeasuredDimension(int width, int height) {
        this.width = width;
    }
}

