/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.angularFaces.core.transformation;

import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class AttributeUtilities {
    private static final Logger LOGGER = Logger.getLogger("de.beyondjava.angularFaces.core.transformation.AttributeUtilities");

    public static Object getAttribute(UIComponent component, String attributeName) {
        Object value = component.getPassThroughAttributes().get(attributeName);
        if (null == value) {
            value = component.getAttributes().get(attributeName);
        }
        if (null == value && !attributeName.equals(attributeName.toLowerCase())) {
            return AttributeUtilities.getAttribute(component, attributeName.toLowerCase());
        }
        if (value instanceof ValueExpression) {
            value = ((ValueExpression)value).getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return value;
    }

    public static String getAttributeAsString(UIComponent component, String attributeName) {
        try {
            ValueExpression vex;
            Object attribute = AttributeUtilities.getAttribute(component, attributeName);
            if (null != attribute) {
                if (attribute instanceof ValueExpression) {
                    return (String)((ValueExpression)attribute).getValue(FacesContext.getCurrentInstance().getELContext());
                }
                if (attribute instanceof String) {
                    return (String)attribute;
                }
                LOGGER.severe("unexpected data type of label: " + attributeName + " type:" + attribute.getClass().getName());
                return "unexpected data type of label: " + attributeName + " type:" + attribute.getClass().getName();
            }
            if (null == attribute && null != (vex = component.getValueExpression(attributeName))) {
                return (String)vex.getValue(FacesContext.getCurrentInstance().getELContext());
            }
        }
        catch (ClassCastException error) {
            LOGGER.fine("Attribute is not a String: " + attributeName);
        }
        return null;
    }
}

