/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.impl;

import brainslug.flow.execution.Execute;
import brainslug.flow.execution.ExecutionContext;
import brainslug.flow.execution.impl.DefaultNodeExecutor;
import brainslug.flow.model.AbstractTaskDefinition;
import brainslug.flow.model.FlowNodeDefinition;
import brainslug.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.List;

public class TaskNodeExecutor
extends DefaultNodeExecutor<AbstractTaskDefinition> {
    @Override
    public List<FlowNodeDefinition> execute(AbstractTaskDefinition taskDefinition, ExecutionContext context) {
        if (taskDefinition.getDelegateClass() != null) {
            this.executeDelegate(taskDefinition, context);
        }
        if (taskDefinition.getMethodCall() != null) {
            this.executeMethodCall(taskDefinition, context);
        }
        return this.takeAll((FlowNodeDefinition<?>)taskDefinition);
    }

    private void executeMethodCall(AbstractTaskDefinition taskDefinition, ExecutionContext context) {
        Class serviceClass = taskDefinition.getMethodCall().getServiceClass();
        Object serviceInstance = context.getBrainslugContext().getRegistry().getService(serviceClass);
        this.invokeServiceWithArguments(taskDefinition, serviceClass, serviceInstance);
    }

    private void invokeServiceWithArguments(AbstractTaskDefinition taskDefinition, Class<?> serviceClass, Object serviceInstance) {
        try {
            Method serviceMethod = serviceClass.getMethod(taskDefinition.getMethodCall().getMethodName(), new Class[0]);
            serviceMethod.invoke(serviceInstance, taskDefinition.getMethodCall().getArguments().toArray());
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    private void executeDelegate(AbstractTaskDefinition taskDefinition, ExecutionContext context) {
        Object serviceInstance = context.getBrainslugContext().getRegistry().getService(taskDefinition.getDelegateClass());
        Method executeMethod = ReflectionUtil.getFirstMethodAnnotatedWith(taskDefinition.getDelegateClass(), Execute.class);
        this.invokeServiceMethodWithContext(context, serviceInstance, executeMethod);
    }

    private void invokeServiceMethodWithContext(ExecutionContext context, Object serviceInstance, Method executeMethod) {
        try {
            executeMethod.invoke(serviceInstance, context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

