/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.expression;

import brainslug.flow.context.BrainslugContext;
import brainslug.flow.context.PredicateEvaluator;
import brainslug.flow.execution.expression.ServiceCall;
import brainslug.flow.model.MethodCallDefinition;
import brainslug.flow.model.expression.Constant;
import brainslug.flow.model.expression.EqualDefinition;
import brainslug.flow.model.expression.Expression;
import java.lang.reflect.Method;

public class DefaultPredicateEvaluator
implements PredicateEvaluator {
    BrainslugContext context;

    public DefaultPredicateEvaluator(BrainslugContext context) {
        this.context = context;
    }

    @Override
    public boolean evaluate(EqualDefinition predicate) {
        return this.getValue(predicate).equals(this.getExpectedValue(predicate));
    }

    private Object getExpectedValue(EqualDefinition predicate) {
        if (predicate.getExpectedValue() instanceof Constant) {
            return ((Constant)predicate.getExpectedValue()).getValue();
        }
        return predicate.getExpectedValue();
    }

    private Object getValue(EqualDefinition predicate) {
        Object expressionValue;
        if (predicate.getActual() instanceof Expression && (expressionValue = ((Expression)predicate.getActual()).getValue()) instanceof ServiceCall) {
            return ((ServiceCall)expressionValue).call(this.context.getRegistry());
        }
        if (predicate.getActual() instanceof Constant) {
            return ((Constant)predicate.getActual()).getValue();
        }
        if (predicate.getActual() instanceof MethodCallDefinition) {
            return this.invokeMethod((MethodCallDefinition)predicate.getActual());
        }
        throw new UnsupportedOperationException("unable to evaluate " + predicate);
    }

    private Object invokeMethod(MethodCallDefinition methodDefinition) {
        try {
            Method method = methodDefinition.getServiceClass().getMethod(methodDefinition.getMethodName(), new Class[0]);
            Object methodResult = method.invoke(this.context.getRegistry().getService(methodDefinition.getServiceClass()), new Object[0]);
            return methodResult;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

