/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.event;

import brainslug.flow.context.BrainslugContext;
import brainslug.flow.event.EventDispatcher;
import brainslug.flow.event.FlowEvent;
import brainslug.flow.event.Subscriber;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;

public class SynchronousEventDispatcher
implements EventDispatcher {
    BrainslugContext context;
    Set<Subscriber> subscribers = Collections.synchronizedSet(new HashSet());
    LinkedBlockingDeque<FlowEvent> queue = new LinkedBlockingDeque();

    @Override
    public void push(FlowEvent event) {
        this.queue.push(event);
    }

    @Override
    public void dispatch() {
        while (!this.queue.isEmpty()) {
            FlowEvent event = this.queue.pop();
            this.notifySubscribers(event);
        }
    }

    private void notifySubscribers(FlowEvent event) {
        for (Subscriber subscriber : this.subscribers) {
            subscriber.notify(event);
        }
    }

    @Override
    public void addSubscriber(Subscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    @Override
    public void removeSubscriber(Subscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    @Override
    public void setContext(BrainslugContext context) {
        this.context = context;
    }
}

