/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.context;

import brainslug.flow.context.HashMapRegistry;
import brainslug.flow.context.IdGenerator;
import brainslug.flow.context.PredicateEvaluator;
import brainslug.flow.context.Registry;
import brainslug.flow.event.EventDispatcher;
import brainslug.flow.event.FlowEvent;
import brainslug.flow.event.SynchronousEventDispatcher;
import brainslug.flow.execution.FlowExecutor;
import brainslug.flow.execution.expression.DefaultPredicateEvaluator;
import brainslug.flow.execution.impl.HashMapTokenStore;
import brainslug.flow.execution.impl.TokenFlowExecutor;
import brainslug.flow.model.FlowDefinition;
import brainslug.flow.model.FlowDefinitions;
import brainslug.flow.model.Identifier;
import brainslug.util.UuidGenerator;

public class BrainslugContext {
    FlowDefinitions flowDefinitions = new FlowDefinitions();
    EventDispatcher eventDispatcher;
    FlowExecutor flowExecutor;
    PredicateEvaluator predicateEvaluator;
    IdGenerator idGenerator;
    Registry registry;

    public BrainslugContext() {
        this.withDispatcher(new SynchronousEventDispatcher());
        this.withExecutor(new TokenFlowExecutor(new HashMapTokenStore()));
        this.withRegistry(new HashMapRegistry());
        this.withPredicateEvaluator(new DefaultPredicateEvaluator(this));
        this.withIdGenerator(new UuidGenerator());
    }

    public BrainslugContext withExecutor(FlowExecutor newFlowExecutor) {
        this.eventDispatcher.removeSubscriber(this.flowExecutor);
        this.setupFlowExecutor(newFlowExecutor);
        return this;
    }

    private void setupFlowExecutor(FlowExecutor newFlowExecutor) {
        this.flowExecutor = newFlowExecutor;
        this.flowExecutor.setContext(this);
        this.eventDispatcher.addSubscriber(newFlowExecutor);
    }

    public BrainslugContext withDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
        return this;
    }

    public BrainslugContext withRegistry(Registry registry) {
        this.registry = registry;
        return this;
    }

    public BrainslugContext withPredicateEvaluator(PredicateEvaluator predicateEvaluator) {
        this.predicateEvaluator = predicateEvaluator;
        return this;
    }

    public BrainslugContext withIdGenerator(UuidGenerator uuidGenerator) {
        this.idGenerator = uuidGenerator;
        return this;
    }

    public BrainslugContext addFlowDefinition(FlowDefinition flowDefinition) {
        this.flowDefinitions.addDefinition(flowDefinition);
        return this;
    }

    public FlowDefinitions getFlowDefinitions() {
        return this.flowDefinitions;
    }

    public void trigger(FlowEvent event) {
        this.eventDispatcher.push(event);
        this.eventDispatcher.dispatch();
    }

    public Identifier startFlow(Identifier definitionId, Identifier nodeId) {
        return this.flowExecutor.startFlow(definitionId, nodeId);
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public PredicateEvaluator getPredicateEvaluator() {
        return this.predicateEvaluator;
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }
}

