/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.token;

import brainslug.flow.definition.Identifier;
import brainslug.flow.instance.FlowInstanceToken;
import brainslug.util.IdUtil;
import brainslug.util.Option;

public class Token
implements FlowInstanceToken {
    Identifier id;
    Identifier nodeId;
    Option<Identifier> sourceNode;
    Identifier instanceId;
    boolean isDead;
    boolean isFinal;

    public Token(String id, String nodeId, String sourceNodeId, String instanceId, int isDead, int isFinal) {
        this(IdUtil.id((String)id), IdUtil.id((String)nodeId), (Option<Identifier>)Option.of((Object)IdUtil.id((String)sourceNodeId)), IdUtil.id((String)instanceId), isDead == 1, isFinal == 1);
    }

    public Token(Identifier id, Identifier nodeId, Option<Identifier> sourceNode, Identifier instanceId, boolean isDead, boolean isFinal) {
        this.id = id;
        this.nodeId = nodeId;
        this.sourceNode = sourceNode;
        this.instanceId = instanceId;
        this.isDead = isDead;
        this.isFinal = isFinal;
    }

    public Identifier getId() {
        return this.id;
    }

    public Identifier getNodeId() {
        return this.nodeId;
    }

    public Option<Identifier> getSourceNodeId() {
        return this.sourceNode;
    }

    public Identifier getInstanceId() {
        return this.instanceId;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setDead(boolean isDead) {
        this.isDead = isDead;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        if (this.isDead != token.isDead) {
            return false;
        }
        if (this.isFinal != token.isFinal) {
            return false;
        }
        if (this.id != null ? !this.id.equals(token.id) : token.id != null) {
            return false;
        }
        if (this.nodeId != null ? !this.nodeId.equals(token.nodeId) : token.nodeId != null) {
            return false;
        }
        if (this.sourceNode != null ? !this.sourceNode.equals(token.sourceNode) : token.sourceNode != null) {
            return false;
        }
        return !(this.instanceId == null ? token.instanceId != null : !this.instanceId.equals(token.instanceId));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        result = 31 * result + (this.sourceNode != null ? this.sourceNode.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.isDead ? 1 : 0);
        result = 31 * result + (this.isFinal ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Token{id=" + this.id + ", nodeId=" + this.nodeId + ", sourceNode=" + this.sourceNode + ", instanceId=" + this.instanceId + ", isDead=" + this.isDead + ", isFinal=" + this.isFinal + '}';
    }
}

