/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.node;

import brainslug.flow.context.ExecutionContext;
import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.node.DefaultNodeExecutor;
import brainslug.flow.execution.node.FlowNodeExecutionResult;
import brainslug.flow.instance.FlowInstanceToken;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.JoinDefinition;
import brainslug.flow.path.FlowEdgeDefinition;
import brainslug.util.Option;
import java.util.ArrayList;
import java.util.List;

public class JoinNodeExecutor
extends DefaultNodeExecutor<JoinDefinition> {
    @Override
    public FlowNodeExecutionResult execute(JoinDefinition joinDefinition, ExecutionContext execution) {
        List joinTokens = execution.getInstance().getTokens().getNodeTokens(joinDefinition.getId());
        FlowNodeExecutionResult takeAll = this.takeAll((FlowNodeDefinition<?>)joinDefinition);
        for (FlowEdgeDefinition edge : joinDefinition.getIncoming()) {
            List<FlowInstanceToken> edgeTokens = this.getEdgeTokens(edge, joinTokens);
            if (edgeTokens.isEmpty()) {
                return this.takeNone((FlowNodeDefinition<?>)joinDefinition, execution.getInstance());
            }
            takeAll.withRemovedTokens(joinDefinition.getId(), (Option<Identifier>)Option.of((Object)edge.getSource().getId()), 1);
        }
        return takeAll;
    }

    private List<FlowInstanceToken> getEdgeTokens(FlowEdgeDefinition edge, List<FlowInstanceToken> joinTokens) {
        ArrayList<FlowInstanceToken> edgeTokens = new ArrayList<FlowInstanceToken>();
        for (FlowInstanceToken joinToken : joinTokens) {
            if (!joinToken.getSourceNodeId().isPresent() || !((Identifier)joinToken.getSourceNodeId().get()).equals(edge.getSource().getId())) continue;
            edgeTokens.add(joinToken);
        }
        return edgeTokens;
    }
}

