/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.node;

import brainslug.flow.definition.Identifier;
import brainslug.flow.instance.FlowInstanceToken;
import brainslug.flow.instance.FlowInstanceTokenList;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.util.Option;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FlowNodeExecutionResult {
    protected List<TokenRemoval> removedTokens = new ArrayList<TokenRemoval>();
    protected List<FlowNodeDefinition> nextNodes;
    protected boolean failed;
    private FlowNodeDefinition<?> executedNode;

    public FlowNodeExecutionResult(FlowNodeDefinition<?> executedNode) {
        this.executedNode = executedNode;
        this.nextNodes = new ArrayList<FlowNodeDefinition>();
    }

    public FlowNodeExecutionResult(FlowNodeDefinition<?> executedNode, List<FlowNodeDefinition> nextNodes) {
        this.executedNode = executedNode;
        this.nextNodes = nextNodes;
    }

    public List<FlowNodeDefinition> getNextNodes() {
        return this.nextNodes;
    }

    public List<TokenRemoval> getRemovedTokens() {
        return this.removedTokens;
    }

    public FlowNodeExecutionResult withNext(FlowNodeDefinition next) {
        this.nextNodes.add(next);
        return this;
    }

    public FlowNodeExecutionResult withFirstIncomingTokensRemoved(FlowInstanceTokenList tokenList) {
        List nodeTokens = tokenList.getNodeTokens(this.executedNode.getId());
        HashMap<Object, Boolean> removedFrom = new HashMap<Object, Boolean>();
        for (FlowInstanceToken nodeToken : nodeTokens) {
            if (nodeToken.getSourceNodeId().isPresent() && removedFrom.get(nodeToken.getSourceNodeId().get()) == null) {
                this.withRemovedTokens(nodeToken.getNodeId(), (Option<Identifier>)nodeToken.getSourceNodeId(), 1);
                removedFrom.put(nodeToken.getSourceNodeId().get(), true);
                continue;
            }
            this.withRemovedTokens(nodeToken.getNodeId(), (Option<Identifier>)Option.empty(), 1);
        }
        return this;
    }

    public FlowNodeExecutionResult withRemovedTokens(Identifier nodeId, Option<Identifier> sourceId, Integer quantity) {
        this.removedTokens.add(new TokenRemoval(nodeId, sourceId, quantity));
        return this;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public FlowNodeExecutionResult failed(boolean failed) {
        this.failed = failed;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowNodeExecutionResult that = (FlowNodeExecutionResult)o;
        if (this.failed != that.failed) {
            return false;
        }
        if (this.removedTokens != null ? !this.removedTokens.equals(that.removedTokens) : that.removedTokens != null) {
            return false;
        }
        if (this.nextNodes != null ? !this.nextNodes.equals(that.nextNodes) : that.nextNodes != null) {
            return false;
        }
        return !(this.executedNode == null ? that.executedNode != null : !this.executedNode.equals(that.executedNode));
    }

    public int hashCode() {
        int result = this.removedTokens != null ? this.removedTokens.hashCode() : 0;
        result = 31 * result + (this.nextNodes != null ? this.nextNodes.hashCode() : 0);
        result = 31 * result + (this.failed ? 1 : 0);
        result = 31 * result + (this.executedNode != null ? this.executedNode.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FlowNodeExecutionResult{removedTokens=" + this.removedTokens + ", nextNodes=" + this.nextNodes + ", failed=" + this.failed + ", executedNode=" + this.executedNode + '}';
    }

    public static class TokenRemoval {
        Identifier nodeId;
        Option<Identifier> sourceId;
        Integer quantity;

        public TokenRemoval(Identifier nodeId, Option<Identifier> sourceId, Integer quantity) {
            this.nodeId = nodeId;
            this.sourceId = sourceId;
            this.quantity = quantity;
        }

        public Identifier getNodeId() {
            return this.nodeId;
        }

        public Option<Identifier> getSourceId() {
            return this.sourceId;
        }

        public Integer getQuantity() {
            return this.quantity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TokenRemoval that = (TokenRemoval)o;
            if (this.nodeId != null ? !this.nodeId.equals(that.nodeId) : that.nodeId != null) {
                return false;
            }
            if (this.sourceId != null ? !this.sourceId.equals(that.sourceId) : that.sourceId != null) {
                return false;
            }
            return !(this.quantity == null ? that.quantity != null : !this.quantity.equals(that.quantity));
        }

        public int hashCode() {
            int result = this.nodeId != null ? this.nodeId.hashCode() : 0;
            result = 31 * result + (this.sourceId != null ? this.sourceId.hashCode() : 0);
            result = 31 * result + (this.quantity != null ? this.quantity.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "TokenRemoval{nodeId=" + this.nodeId + ", sourceId=" + this.sourceId + ", quantity=" + this.quantity + '}';
        }
    }
}

