/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.node;

import brainslug.flow.context.ExecutionContext;
import brainslug.flow.execution.expression.ExpressionEvaluator;
import brainslug.flow.execution.node.DefaultNodeExecutor;
import brainslug.flow.execution.node.FlowNodeExecutionResult;
import brainslug.flow.node.ChoiceDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.path.ThenDefinition;

public class ChoiceNodeExecutor
extends DefaultNodeExecutor<ChoiceDefinition> {
    private ExpressionEvaluator expressionEvaluator;

    public ChoiceNodeExecutor(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    public FlowNodeExecutionResult execute(ChoiceDefinition choiceDefinition, ExecutionContext execution) {
        for (ThenDefinition thenPath : choiceDefinition.getThenPaths()) {
            if (!this.expressionEvaluator.evaluate(thenPath.getExpression(), execution, Boolean.class).booleanValue()) continue;
            return new FlowNodeExecutionResult((FlowNodeDefinition<?>)choiceDefinition).withNext(thenPath.getFirstPathNode());
        }
        return this.tryOtherwise(choiceDefinition, execution);
    }

    FlowNodeExecutionResult tryOtherwise(ChoiceDefinition choiceDefinition, ExecutionContext execution) {
        if (choiceDefinition.getOtherwisePath().isPresent()) {
            return new FlowNodeExecutionResult((FlowNodeDefinition<?>)choiceDefinition).withNext(((ThenDefinition)choiceDefinition.getOtherwisePath().get()).getFirstPathNode());
        }
        throw new IllegalStateException("no choice path was eligible for execution and no default path was set. " + choiceDefinition + ", content: " + execution);
    }
}

