/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.instance;

import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.instance.DefaultFlowInstance;
import brainslug.flow.execution.instance.InstanceStore;
import brainslug.flow.execution.property.store.PropertyStore;
import brainslug.flow.execution.token.TokenStore;
import brainslug.flow.expression.EqualsExpression;
import brainslug.flow.expression.Property;
import brainslug.flow.expression.Value;
import brainslug.flow.instance.FlowInstance;
import brainslug.flow.instance.FlowInstanceProperties;
import brainslug.flow.instance.FlowInstanceProperty;
import brainslug.flow.instance.FlowInstanceSelector;
import brainslug.util.IdGenerator;
import brainslug.util.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HashMapInstanceStore
implements InstanceStore {
    final IdGenerator idGenerator;
    final PropertyStore propertyStore;
    private TokenStore tokenStore;
    final Map<Identifier, Map<Identifier, FlowInstance>> instancesByDefinitionId;
    final Map<Identifier, FlowInstance> instancesById;

    public HashMapInstanceStore(IdGenerator idGenerator, PropertyStore propertyStore, TokenStore tokenStore) {
        this.idGenerator = idGenerator;
        this.propertyStore = propertyStore;
        this.tokenStore = tokenStore;
        this.instancesByDefinitionId = new ConcurrentHashMap<Identifier, Map<Identifier, FlowInstance>>();
        this.instancesById = new ConcurrentHashMap<Identifier, FlowInstance>();
    }

    public List<FlowInstance> findInstances(FlowInstanceSelector instanceSelector) {
        return this.filterProperties(instanceSelector.properties(), this.instancesByFlowIdAndInstanceId(instanceSelector));
    }

    private List<FlowInstance> filterProperties(Collection<EqualsExpression<Property<?>, Value<String>>> propertyExpressions, List<FlowInstance> flowInstances) {
        if (propertyExpressions.isEmpty()) {
            return flowInstances;
        }
        ArrayList<FlowInstance> filteredInstances = new ArrayList<FlowInstance>();
        for (FlowInstance flowInstance : flowInstances) {
            FlowInstanceProperties<?, FlowInstanceProperty<?>> instanceProperties = this.propertyStore.getProperties(flowInstance.getIdentifier());
            for (EqualsExpression<Property<?>, Value<String>> propertyExpression : propertyExpressions) {
                FlowInstanceProperty propertyValue = (FlowInstanceProperty)instanceProperties.get(((Identifier)((Property)propertyExpression.getLeft()).getValue()).stringValue());
                if (propertyValue == null || !propertyValue.getValue().equals(((Value)propertyExpression.getRight()).getValue())) continue;
                filteredInstances.add(flowInstance);
            }
        }
        return filteredInstances;
    }

    private List<FlowInstance> instancesByFlowIdAndInstanceId(FlowInstanceSelector instanceSelector) {
        if (!instanceSelector.definitionId().isPresent() && !instanceSelector.instanceId().isPresent()) {
            throw new IllegalArgumentException("you need to specify either instance or definition identifier");
        }
        if (instanceSelector.definitionId().isPresent() && !instanceSelector.instanceId().isPresent()) {
            return this.instancesByDefinitionId((Identifier)instanceSelector.definitionId().get());
        }
        if (instanceSelector.instanceId().isPresent() && instanceSelector.definitionId().isPresent()) {
            return this.emptyOrSingletonListFromNullable(this.instanceByDefinitionIdAndInstanceId(instanceSelector));
        }
        return this.emptyOrSingletonListFromNullable((FlowInstance)this.instanceByInstanceId((Identifier)instanceSelector.instanceId().get()).orElse(null));
    }

    List<FlowInstance> emptyOrSingletonListFromNullable(FlowInstance instance) {
        if (instance == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(instance);
    }

    protected FlowInstance instanceByDefinitionIdAndInstanceId(FlowInstanceSelector instanceSelector) {
        return this.getOrCreateInstanceMap((Identifier)instanceSelector.definitionId().get()).get(instanceSelector.instanceId().get());
    }

    public Option<FlowInstance> findInstance(FlowInstanceSelector instanceSelector) {
        List<FlowInstance> instances = this.filterProperties(instanceSelector.properties(), this.instancesByFlowIdAndInstanceId(instanceSelector));
        if (instances.isEmpty()) {
            return Option.empty();
        }
        return Option.of((Object)instances.get(0));
    }

    protected List<FlowInstance> instancesByDefinitionId(Identifier definitionId) {
        return new ArrayList<FlowInstance>(this.getOrCreateInstanceMap(definitionId).values());
    }

    protected Option<FlowInstance> instanceByInstanceId(Identifier instanceId) {
        return Option.of((Object)this.instancesById.get(instanceId));
    }

    @Override
    public FlowInstance createInstance(Identifier definitionId) {
        Identifier instanceId = this.idGenerator.generateId();
        DefaultFlowInstance newInstance = new DefaultFlowInstance(instanceId, definitionId, this.propertyStore, this.tokenStore);
        this.addInstanceToDefinitionInstances(definitionId, newInstance);
        this.instancesById.put(instanceId, newInstance);
        return newInstance;
    }

    private List<FlowInstance> addInstanceToDefinitionInstances(Identifier definitionId, DefaultFlowInstance newInstance) {
        Map<Identifier, FlowInstance> definitionInstanceMap = this.getOrCreateInstanceMap(definitionId);
        definitionInstanceMap.put(newInstance.getIdentifier(), newInstance);
        return new ArrayList<FlowInstance>(definitionInstanceMap.values());
    }

    private Map<Identifier, FlowInstance> getOrCreateInstanceMap(Identifier definitionId) {
        if (this.instancesByDefinitionId.get(definitionId) == null) {
            this.instancesByDefinitionId.put(definitionId, new ConcurrentHashMap());
        }
        return this.instancesByDefinitionId.get(definitionId);
    }
}

