/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.expression;

import brainslug.flow.context.ExecutionContext;
import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.expression.ContextPredicate;
import brainslug.flow.execution.expression.ExpressionEvaluator;
import brainslug.flow.execution.expression.PropertyPredicate;
import brainslug.flow.execution.node.task.CallDefinitionExecutor;
import brainslug.flow.expression.EqualsExpression;
import brainslug.flow.expression.Expression;
import brainslug.flow.expression.Property;
import brainslug.flow.expression.Value;
import brainslug.flow.node.task.CallDefinition;

public class DefaultExpressionEvaluator
implements ExpressionEvaluator {
    @Override
    public <T> T evaluate(Expression expression, ExecutionContext context, Class<T> expectedType) {
        Object expressionValue = this.evaluateExpression(expression, context);
        if (!expressionValue.getClass().isAssignableFrom(expectedType)) {
            throw new IllegalArgumentException("the expression " + expression + "did not evaluate to expected result type: " + expectedType);
        }
        return expectedType.cast(expressionValue);
    }

    protected Object evaluateExpression(Expression expression, ExecutionContext context) {
        if (expression instanceof EqualsExpression) {
            EqualsExpression equalsExpression = (EqualsExpression)expression;
            return this.getValue(equalsExpression.getLeft(), context).equals(this.getValue(equalsExpression.getRight(), context));
        }
        throw new IllegalArgumentException("unknown expression type " + expression.getClass());
    }

    private Object propertyValue(Property<?> property, ExecutionContext context) {
        String propertyId = ((Identifier)property.getValue()).getId().toString();
        return context.property(propertyId, Object.class);
    }

    private Object getValue(Expression expression, ExecutionContext context) {
        if (expression instanceof Property) {
            return this.propertyValue((Property)expression, context);
        }
        if (expression instanceof Value) {
            return this.valueOf(((Value)expression).getValue(), context);
        }
        return this.evaluateExpression(expression, context);
    }

    private Object valueOf(Object value, ExecutionContext context) {
        if (value instanceof ContextPredicate) {
            return ((ContextPredicate)value).isFulfilled(context);
        }
        if (value instanceof PropertyPredicate) {
            return ((PropertyPredicate)value).isFulfilled(context.getProperties());
        }
        if (value instanceof CallDefinition) {
            return this.executeCall((CallDefinition)value, context);
        }
        if (value instanceof Value) {
            return this.valueOf(((Value)value).getValue(), context);
        }
        return value;
    }

    private Object executeCall(CallDefinition actual, ExecutionContext context) {
        return new CallDefinitionExecutor().execute(actual, context);
    }
}

