/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.async;

import brainslug.flow.context.BrainslugContext;
import brainslug.flow.context.Trigger;
import brainslug.flow.execution.async.AsyncTrigger;
import brainslug.flow.execution.async.AsyncTriggerErrorDetails;
import brainslug.flow.execution.async.AsyncTriggerExecutionResult;
import brainslug.flow.execution.async.AsyncTriggerStore;
import brainslug.flow.node.task.RetryStrategy;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTriggerExecutor {
    private Logger log = LoggerFactory.getLogger(AsyncTriggerExecutor.class);

    public AsyncTriggerExecutionResult execute(AsyncTrigger asyncTrigger, RetryStrategy retryStrategy, BrainslugContext context, AsyncTriggerStore asyncTriggerStore) {
        this.log.debug("executing async task: {}", (Object)asyncTrigger);
        AsyncTriggerExecutionResult execution = this.trigger(asyncTrigger, context);
        if (execution.isFailed()) {
            this.setErrorDetailsAndRetry(asyncTrigger, execution, retryStrategy, asyncTriggerStore);
        } else {
            this.removeTrigger(asyncTrigger, asyncTriggerStore);
        }
        return execution;
    }

    protected void setErrorDetailsAndRetry(AsyncTrigger asyncTrigger, AsyncTriggerExecutionResult execution, RetryStrategy retryStrategy, AsyncTriggerStore asyncTriggerStore) {
        asyncTriggerStore.updateTrigger(asyncTrigger.incrementRetries().withDueDate(retryStrategy.nextRetry(asyncTrigger.getRetries(), this.getBaseDate()).getTime()).withErrorDetails(new AsyncTriggerErrorDetails((Exception)execution.getException().get())));
    }

    protected void removeTrigger(AsyncTrigger asyncTrigger, AsyncTriggerStore asyncTriggerStore) {
        if (!asyncTriggerStore.removeTrigger(asyncTrigger)) {
            throw new IllegalStateException("unable to remove task " + asyncTrigger);
        }
    }

    protected AsyncTriggerExecutionResult trigger(AsyncTrigger asyncTrigger, BrainslugContext context) {
        try {
            context.trigger(((Trigger)((Trigger)((Trigger)((Trigger)new Trigger().instanceId(asyncTrigger.getInstanceId())).definitionId(asyncTrigger.getDefinitionId())).nodeId(asyncTrigger.getNodeId())).async(true)).signaling(true));
            return new AsyncTriggerExecutionResult();
        }
        catch (Exception e) {
            return new AsyncTriggerExecutionResult().setFailed(true).withException(e);
        }
    }

    public Date getBaseDate() {
        return new Date();
    }
}

