/*
 * Decompiled with CFR 0.152.
 */
package brainslug.example.spring;

import brainslug.flow.builder.FlowBuilder;
import brainslug.flow.context.BrainslugContext;
import brainslug.flow.context.ExecutionContext;
import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.property.ExecutionProperties;
import brainslug.flow.instance.FlowInstanceProperties;
import brainslug.flow.node.task.Task;
import brainslug.spring.SpringBrainslugConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Configuration
@Import(value={SpringBrainslugConfiguration.class})
public class ConfigurationExample {
    @Bean
    FlowBuilder flowBuilder() {
        return new FlowBuilder(){

            public void define() {
                this.flowId(1.id((String)"spring-flow"));
                this.start(1.task((Identifier)1.id((String)"spring-task")).delegate(SpringExampleTask.class));
            }
        };
    }

    public static void main(String[] args) {
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext(new Class[]{ConfigurationExample.class});
        BrainslugContext brainslugContext = (BrainslugContext)applicationContext.getBean(BrainslugContext.class);
        brainslugContext.startFlow(FlowBuilder.id((String)"spring-flow"), (FlowInstanceProperties)ExecutionProperties.newProperties().with("name", (Object)"World"));
    }

    @Component
    public static class SpringExampleTask
    implements Task {
        Environment environment;

        @Autowired
        public SpringExampleTask(Environment environment) {
            this.environment = environment;
        }

        public void execute(ExecutionContext context) {
            this.printHello((String)context.property("name", String.class));
            ((SpringExampleTask)context.service(SpringExampleTask.class)).printHello("again");
        }

        public void printHello(String name) {
            System.out.println(String.format("Hello %s!", name));
        }
    }
}

