/*
 * Decompiled with CFR 0.152.
 */
package brainslug.example;

import brainslug.flow.builder.FlowBuilder;
import brainslug.flow.definition.Identifier;
import brainslug.flow.expression.EqualsExpression;
import brainslug.flow.expression.Expression;
import brainslug.flow.expression.Value;
import brainslug.flow.node.ChoiceDefinition;
import brainslug.flow.node.EventDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.TaskDefinition;
import brainslug.flow.node.event.AbstractEventDefinition;
import brainslug.flow.node.task.AbstractTaskDefinition;
import brainslug.flow.path.AndDefinition;
import brainslug.flow.path.ThenDefinition;
import java.util.concurrent.TimeUnit;

public class ControlFlowExamples {

    static class ParallelFlow
    extends FlowBuilder {
        Identifier parallelFlowId = ParallelFlow.id((String)"parallel_flow");
        EventDefinition flowStart = ParallelFlow.event((Identifier)ParallelFlow.id((String)"start"));
        EventDefinition flowEnd = (EventDefinition)ParallelFlow.event((Identifier)ParallelFlow.id((String)"end")).display("end");
        TaskDefinition firstTask = (TaskDefinition)ParallelFlow.task((Identifier)ParallelFlow.id((String)"first_task")).display("Do Something");
        TaskDefinition secondTask = (TaskDefinition)ParallelFlow.task((Identifier)ParallelFlow.id((String)"second_task")).display("Do another Thing");

        ParallelFlow() {
        }

        public void define() {
            this.flowId(this.parallelFlowId);
            ((AndDefinition)this.start((AbstractEventDefinition)this.flowStart).parallel(ParallelFlow.id()).execute((AbstractTaskDefinition)this.firstTask)).and().execute((AbstractTaskDefinition)this.secondTask);
            this.join(new FlowNodeDefinition[]{this.firstTask, this.secondTask}).end((FlowNodeDefinition)this.flowEnd);
        }
    }

    static class ChoiceFlow
    extends FlowBuilder {
        Identifier choiceFlowId = ChoiceFlow.id((String)"choiceFlow");
        EventDefinition choiceFlowStart = ChoiceFlow.event((Identifier)ChoiceFlow.id((String)"start"));
        EventDefinition choiceEnd = (EventDefinition)ChoiceFlow.event((Identifier)ChoiceFlow.id((String)"end")).display("end");
        Identifier meaningOfLiveChoice = ChoiceFlow.id((String)"meaning_choice");
        Value meaningProperty = ChoiceFlow.property((Identifier)ChoiceFlow.id((String)"meaning"));
        EqualsExpression equalsFortyTwo = ChoiceFlow.eq((Expression)this.meaningProperty, (Object)42);
        EqualsExpression equalsFortyThree = ChoiceFlow.eq((Expression)this.meaningProperty, (Object)43);
        TaskDefinition meaningfulTask = (TaskDefinition)ChoiceFlow.task((Identifier)ChoiceFlow.id((String)"meaning_ful")).display("Meaningful Task");
        TaskDefinition meaninglessTask = (TaskDefinition)ChoiceFlow.task((Identifier)ChoiceFlow.id((String)"meaning_less")).display("Meaningless Task");

        ChoiceFlow() {
        }

        public void define() {
            this.flowId(this.choiceFlowId);
            ((ThenDefinition)((ChoiceDefinition)this.start((AbstractEventDefinition)this.choiceFlowStart).choice(this.meaningOfLiveChoice).display("Meaning of live?")).when((Expression)this.equalsFortyTwo).execute((AbstractTaskDefinition)this.meaningfulTask)).or().when((Expression)this.equalsFortyThree).execute((AbstractTaskDefinition)this.meaninglessTask);
            this.merge(new FlowNodeDefinition[]{this.meaningfulTask, this.meaninglessTask}).end((FlowNodeDefinition)this.choiceEnd);
        }
    }

    static class EventFlow
    extends FlowBuilder {
        Identifier eventFlowId = EventFlow.id((String)"helloFlow");
        EventDefinition eventFlowStart = (EventDefinition)EventFlow.event((Identifier)EventFlow.id((String)"start")).display("Every 5 Seconds");
        EventDefinition fiveSecondsPassed = (EventDefinition)((EventDefinition)EventFlow.event((Identifier)EventFlow.id((String)"wait")).display("After 5 Seconds")).timePassed(5L, TimeUnit.SECONDS);
        TaskDefinition theTask = (TaskDefinition)EventFlow.task((Identifier)EventFlow.id((String)"doIt")).display("Do Something");

        EventFlow() {
        }

        public void define() {
            this.flowId(this.eventFlowId);
            this.start((AbstractEventDefinition)this.eventFlowStart, this.every(5, TimeUnit.SECONDS)).waitFor((AbstractEventDefinition)this.fiveSecondsPassed).execute((AbstractTaskDefinition)this.theTask);
        }
    }
}

