/*
 * Decompiled with CFR 0.152.
 */
package de.ameto.client;

import de.ameto.client.AddAssetResponse;
import de.ameto.client.AddPipelineError;
import de.ameto.client.AmetoApi;
import de.ameto.client.AmetoException;
import de.ameto.client.Asset;
import de.ameto.client.Job;
import de.ameto.client.Pipeline;
import de.ameto.client.PipelineDto;
import de.ameto.client.operators.Operator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class Ameto {
    private final Retrofit retrofit;
    private final AmetoApi ameto;

    public Ameto(String url, String apiToken) {
        OkHttpClient httpClient = new OkHttpClient.Builder().readTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).addInterceptor(chain -> {
            Request alteredRequest = chain.request().newBuilder().addHeader("Authorization", "Bearer " + apiToken).build();
            return chain.proceed(alteredRequest);
        }).build();
        this.retrofit = new Retrofit.Builder().baseUrl(url).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).client(httpClient).build();
        this.ameto = (AmetoApi)this.retrofit.create(AmetoApi.class);
    }

    public Pipeline add(String name, Operator firstOperator, Operator ... operators) {
        List<Operator> allOperators = Stream.concat(Stream.of(firstOperator), Arrays.stream(operators)).collect(Collectors.toList());
        try {
            List<PipelineDto.Step> steps_ = allOperators.stream().map(operator -> new PipelineDto.Step(operator.getName())).collect(Collectors.toList());
            PipelineDto pipeline = new PipelineDto(name, steps_);
            Response response = this.ameto.add(pipeline).execute();
            if (!response.isSuccessful()) {
                Converter errorConverter = this.retrofit.responseBodyConverter(AddPipelineError.class, new Annotation[0]);
                AddPipelineError error = (AddPipelineError)errorConverter.convert((Object)response.errorBody());
                throw new AmetoException(error.getError());
            }
        }
        catch (IOException e) {
            throw new AmetoException("Unable to send pipeline request to the Ameto API server", e);
        }
        return new Pipeline(this.ameto, name, allOperators);
    }

    public Set<Pipeline> getPipelines() {
        List pipelines;
        try {
            Response response = this.ameto.getPipelines().execute();
            if (!response.isSuccessful()) {
                Converter errorConverter = this.retrofit.responseBodyConverter(AddPipelineError.class, new Annotation[0]);
                AddPipelineError error = (AddPipelineError)errorConverter.convert((Object)response.errorBody());
                throw new AmetoException(error.getError());
            }
            pipelines = (List)response.body();
        }
        catch (IOException e) {
            throw new AmetoException("Unable to send pipeline reuqest to the Ameto API server", e);
        }
        return Collections.unmodifiableSet(pipelines.stream().map(pipelineDto -> new Pipeline(this.ameto, pipelineDto.getName(), pipelineDto.getSteps().stream().map(Ameto::fromStep).collect(Collectors.toList()))).collect(Collectors.toSet()));
    }

    private static Operator fromStep(final PipelineDto.Step step) {
        return new Operator(){

            @Override
            public String getName() {
                return step.getOperator();
            }

            @Override
            public List<String> getConsumes() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Set<Asset> getAssets() {
        Response assetIds;
        try {
            assetIds = this.ameto.getAssets().execute();
        }
        catch (IOException e) {
            throw new AmetoException("Unable to retrieve assets from Ameto.", e);
        }
        if (!assetIds.isSuccessful() || assetIds.body() == null) {
            throw new AmetoException("Unsuccessful response from Ameto. This is either a bug in Ameto or you are using this client with an incompatible version of Ameto (e.g. wrong API version).");
        }
        return Collections.unmodifiableSet(((List)assetIds.body()).stream().map(Asset::new).collect(Collectors.toSet()));
    }

    public Asset add(final InputStream assetContent) {
        try {
            RequestBody body = new RequestBody(){

                public MediaType contentType() {
                    return MediaType.parse((String)"application/octet-stream");
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    try (Source source = Okio.source((InputStream)assetContent);){
                        sink.writeAll(source);
                    }
                }
            };
            Response response = this.ameto.add(body).execute();
            if (!response.isSuccessful() || response.body() == null) {
                throw new AmetoException("Received error response from Ameto API");
            }
            return new Asset(((AddAssetResponse)response.body()).getId());
        }
        catch (IOException e) {
            throw new AmetoException("Unable to upload asset data to ameto.", e);
        }
    }

    public List<Job> getJobs() {
        Response response;
        try {
            response = this.ameto.getJobs().execute();
        }
        catch (IOException e) {
            throw new AmetoException("Unable to send job request to Ameto API.", e);
        }
        List jobs = (List)response.body();
        return Collections.unmodifiableList(jobs.stream().map(job -> new Job(job.getId(), job.getAsset(), job.getPipeline(), this.jobStatus(job.getStatus()))).collect(Collectors.toList()));
    }

    private Job.Status jobStatus(int status) {
        switch (status) {
            case 0: {
                return Job.Status.Pending;
            }
            case 1: {
                return Job.Status.InProgress;
            }
            case 2: {
                return Job.Status.Finished;
            }
            case 3: {
                return Job.Status.Failed;
            }
        }
        throw new IllegalArgumentException("Unknown job status: " + status);
    }
}

