/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.xml.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.alpharogroup.xml.json.ObjectMapperFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public final class ObjectToJsonExtensions {
    public static <T> String toJson(List<T> list) throws JsonGenerationException, JsonMappingException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((OutputStream)out, list);
        byte[] bytes = out.toByteArray();
        out.close();
        return new String(bytes);
    }

    public static <T> String toJson(T object) throws JsonProcessingException {
        return ObjectToJsonExtensions.toJson(object, false);
    }

    public static <T> String toJson(T object, boolean newMapper) throws JsonProcessingException {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper(newMapper);
        String json = mapper.writeValueAsString(object);
        return json;
    }

    private ObjectToJsonExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

