/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.obfuscation.rule;

public enum Operation {
    LOWERCASE,
    TITLECASE,
    UPPERCASE;


    public static Character operate(char character, Operation operation) {
        if (operation != null) {
            switch (operation) {
                case LOWERCASE: {
                    return Character.valueOf(Character.toLowerCase(character));
                }
                case UPPERCASE: {
                    return Character.valueOf(Character.toUpperCase(character));
                }
                case TITLECASE: {
                    return Character.valueOf(Character.toTitleCase(character));
                }
            }
        }
        return Operation.operate(character, operation, false);
    }

    public static Character operate(char character, Operation operation, boolean reverse) {
        if (operation != null) {
            switch (operation) {
                case LOWERCASE: {
                    if (reverse) {
                        return Character.valueOf(Character.toUpperCase(character));
                    }
                    return Character.valueOf(Character.toLowerCase(character));
                }
                case UPPERCASE: {
                    if (reverse) {
                        return Character.valueOf(Character.toLowerCase(character));
                    }
                    return Character.valueOf(Character.toUpperCase(character));
                }
                case TITLECASE: {
                    if (reverse) {
                        if (Character.isUpperCase(character)) {
                            return Character.valueOf(Character.toLowerCase(character));
                        }
                        return Character.valueOf(Character.toUpperCase(character));
                    }
                    return Character.valueOf(Character.toTitleCase(character));
                }
            }
        }
        return Character.valueOf(character);
    }
}

