/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.auth;

import de.alpharogroup.auth.interfaces.Permission;
import de.alpharogroup.auth.interfaces.Role;
import de.alpharogroup.auth.interfaces.Session;
import de.alpharogroup.auth.interfaces.User;
import de.alpharogroup.collections.InsertionOrderMap;
import de.alpharogroup.random.RandomObjectsExtensions;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class UserSession
implements Session<String, String> {
    private static final long serialVersionUID = 2858590853976767758L;
    private String id;
    private Locale locale;
    private Date startTime;
    private User<Permission, Role<Permission>> user;
    private Date lastAccess;
    private int maxInactiveTime;
    private Map<String, String> attributtes;

    public UserSession(User<Permission, Role<Permission>> user) {
        if (null == user) {
            throw new IllegalArgumentException("User can't be null.");
        }
        this.user = user;
        this.initialize();
    }

    @Override
    public String getAttributte(String key) {
        return this.attributtes.get(key);
    }

    @Override
    public Map<String, String> getAttributtes() {
        if (null == this.attributtes) {
            this.attributtes = new InsertionOrderMap();
        }
        return this.attributtes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getLastAccess() {
        return (Date)this.lastAccess.clone();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public int getMaxInactiveTime() {
        return this.maxInactiveTime;
    }

    @Override
    public Date getStartTime() {
        return (Date)this.startTime.clone();
    }

    @Override
    public User<Permission, Role<Permission>> getUser() {
        return this.user;
    }

    private void initialize() {
        this.id = RandomObjectsExtensions.newRandomId();
        this.startTime = new Date(System.currentTimeMillis());
        this.lastAccess = (Date)this.startTime.clone();
        this.maxInactiveTime = 180000;
        this.attributtes = new InsertionOrderMap();
        this.locale = Locale.getDefault();
    }

    @Override
    public String setAttribute(String key, String value) {
        return this.attributtes.put(key, value);
    }

    @Override
    public void setAttributtes(Map<String, String> attributtes) {
        this.attributtes = attributtes;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setLastAccess(Date lastAccess) {
        this.lastAccess = (Date)lastAccess.clone();
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void setMaxInactiveTime(int maxInactiveTime) {
        this.maxInactiveTime = maxInactiveTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.startTime = (Date)startTime.clone();
    }

    @Override
    public void setUser(User<Permission, Role<Permission>> user) {
        this.user = user;
    }
}

