/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.slider.util;

import de.agilecoders.wicket.extensions.slider.ISliderValue;

public class IntegerRangeValue
implements ISliderValue {
    private int min;
    private int max;

    public IntegerRangeValue() {
    }

    public IntegerRangeValue(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public ISliderValue fromString(String value) {
        String toParser = value.indexOf(91) >= 0 ? value.substring(1, value.length() - 1) : value;
        String[] values = toParser.split(",");
        return new IntegerRangeValue(Integer.parseInt(values[0]), Integer.parseInt(values[1]));
    }

    @Override
    public Class<? extends Number> getNumberType() {
        return Integer.class;
    }

    @Override
    public String toString() {
        return "[" + this.min + "," + this.max + "]";
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegerRangeValue)) {
            return false;
        }
        IntegerRangeValue that = (IntegerRangeValue)o;
        if (this.max != that.max) {
            return false;
        }
        return this.min == that.min;
    }

    public int hashCode() {
        int result = this.min ^ this.min >>> 32;
        result = 31 * result + (this.max ^ this.max >>> 32);
        return result;
    }
}

