/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.browser;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import dc.android.base.domain.KeyValueBean;
import dc.android.bridge.fragment.BaseFragment;
import dc.android.common.utils.SharePreferencesUtils;
import dc.android.libs.browser.BaseJavascriptFunction;
import dc.android.libs.browser.IBaseBrowserManager;
import dc.android.libs.browser.R;
import dc.common.Logger;
import java.util.List;

public abstract class BaseBrowserFragment
extends BaseFragment {
    protected TextView tvTitle;
    protected ProgressBar progressBar;
    protected IBaseBrowserManager browserManager;
    BaseJavascriptFunction function;
    String exploreName;
    List<KeyValueBean> listCookie;
    IBaseBrowserManager.LongClickCallback cbClickLong;

    public void init(TextView tvTitle, BaseJavascriptFunction function, String exploreName, List<KeyValueBean> listCookie, IBaseBrowserManager.LongClickCallback cbClickLong) {
        this.tvTitle = tvTitle;
        this.function = function;
        this.exploreName = exploreName;
        this.listCookie = listCookie;
        this.cbClickLong = cbClickLong;
    }

    protected <T extends View> T findView() {
        this.progressBar = (ProgressBar)this.getView().findViewById(R.id.pb_loading);
        return (T)this.getView().findViewById(R.id.webview);
    }

    protected void initData() {
        super.initData();
        this.browserManager.initSettings();
        this.browserManager.setJavascript(this.function, this.exploreName);
        this.browserManager.syncCookie(this.listCookie);
        this.browserManager.setLongClickCallback(this.cbClickLong);
        String url = this.getArguments().getString("var1");
        this.loadPre(url);
        this.setFontSize(new SharePreferencesUtils((Context)this.activity).getSharedPreferencesValue("web_font_size", 1));
    }

    public void refreshData() {
        super.refreshData();
        this.reload();
    }

    protected void loadPre(String url) {
        Logger.w((String)url);
        if (null != url) {
            this.load(url);
        } else {
            Logger.w((Context)this.activity, (String)this.getString(R.string.failed_get));
        }
    }

    protected abstract void load(String var1);

    protected void reload() {
        this.browserManager.reload();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Logger.w((Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), requestCode, resultCode, data});
        switch (resultCode) {
            case 2: {
                this.reload();
            }
        }
    }

    public boolean back() {
        return null == this.browserManager ? false : this.browserManager.back();
    }

    public void onDestroy() {
        super.onDestroy();
        this.destroy();
    }

    protected void destroy() {
        if (null != this.browserManager) {
            this.browserManager.destroy();
        }
    }

    public abstract String getUri();

    public void reloadPage() {
        this.reload();
    }

    public void openInBrowser() {
        this.browserManager.openInBrowser(this.getUri());
    }

    public abstract void setFontSize(int var1);

    public void evaluateJavascript(String function, String[] arrParam, ValueCallback<String> cb) {
    }

    public static interface ValueCallback<T> {
        public void onReceiveValue(T var1);
    }
}

