/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.browser.tbs;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.os.Process;
import android.util.AttributeSet;
import android.view.View;
import com.tencent.smtt.sdk.QbSdk;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebView;
import dc.android.libs.browser.BrowserContext;

public class TbsWebView
extends WebView {
    public TbsWebView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.getView().setClickable(true);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void initSettings() {
        WebSettings webSetting = this.getSettings();
        webSetting.setJavaScriptEnabled(true);
        webSetting.setJavaScriptCanOpenWindowsAutomatically(true);
        webSetting.setAllowFileAccess(true);
        webSetting.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        webSetting.setSupportZoom(true);
        webSetting.setBuiltInZoomControls(true);
        webSetting.setUseWideViewPort(true);
        webSetting.setSupportMultipleWindows(true);
        webSetting.setAppCacheEnabled(true);
        webSetting.setDomStorageEnabled(true);
        webSetting.setGeolocationEnabled(true);
        webSetting.setAppCacheMaxSize(Long.MAX_VALUE);
        webSetting.setPluginState(WebSettings.PluginState.ON_DEMAND);
        webSetting.setCacheMode(2);
    }

    public WebSettings getWebSettings() {
        return this.getSettings();
    }

    public void addAgent(String agent) {
        WebSettings webSettings = this.getSettings();
        webSettings.setUserAgentString(webSettings.getUserAgentString() + agent);
    }

    public void setAgent(String agent) {
        this.getSettings().setUserAgentString(agent);
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        if (!BrowserContext.isDebug) {
            return super.drawChild(canvas, child, drawingTime);
        }
        boolean ret = super.drawChild(canvas, child, drawingTime);
        canvas.save();
        Paint paint = new Paint();
        paint.setColor(0x7FFF0000);
        paint.setTextSize(24.0f);
        paint.setAntiAlias(true);
        String pkgName = this.getContext().getPackageName();
        int pid = Process.myPid();
        if (this.getX5WebViewExtension() != null) {
            canvas.drawText(pkgName + " " + pid, 10.0f, 50.0f, paint);
            canvas.drawText(QbSdk.getTbsVersion((Context)this.getContext()) + "", 10.0f, 100.0f, paint);
        } else {
            canvas.drawText(pkgName + " " + pid, 10.0f, 50.0f, paint);
            canvas.drawText("", 10.0f, 100.0f, paint);
        }
        canvas.drawText(Build.MANUFACTURER, 10.0f, 150.0f, paint);
        canvas.drawText(Build.MODEL, 10.0f, 200.0f, paint);
        canvas.restore();
        return ret;
    }
}

