package dc.android.libs.browser.blink;

import dc.android.libs.browser.BaseBrowserFragment;
import dc.android.libs.browser.R;

import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebSettings;
import dc.common.Logger;

import static dc.android.libs.browser.BrowserContext.WEB_LEVEL_SIZE_BIG;
import static dc.android.libs.browser.BrowserContext.WEB_LEVEL_SIZE_LARGER;
import static dc.android.libs.browser.BrowserContext.WEB_LEVEL_SIZE_NORMAL;
import static dc.android.libs.browser.BrowserContext.WEB_LEVEL_SIZE_SMALL;

/**
 * @author senrsl
 * @ClassName: BlinkFragment
 * @Package: dc.android.libs.browser.blink
 * @CreateTime: 2018/12/24 2:30 PM
 */
public class BlinkFragment extends BaseBrowserFragment {

    private BlinkWebView webView;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_web_blink, container, false);
        return view;
    }

    @Override
    protected void inflatView() {
        super.inflatView();
        webView = findView();
    }

    @Override
    protected void initData() {
        browserManager = new BlinkManagerImpl();
        browserManager.init(activity, tvTitle, progressBar, webView);
        super.initData();
    }


    @Override
    protected void load(String url) {
        webView.loadUrl(url);
    }

    @Override
    public String getUri() {
        Logger.w(webView.getUrl(), webView.getOriginalUrl());
        return webView.getUrl();
    }

    @SuppressWarnings("Duplicates")
    @Override
    public void setFontSize(int sizeLevel) {
        WebSettings.TextSize textSize;
        switch (sizeLevel) {
            case WEB_LEVEL_SIZE_SMALL:
                textSize = WebSettings.TextSize.SMALLER;
                break;
            case WEB_LEVEL_SIZE_BIG:
                textSize = WebSettings.TextSize.LARGER;
                break;
            case WEB_LEVEL_SIZE_LARGER:
                textSize = WebSettings.TextSize.LARGEST;
                break;
            case WEB_LEVEL_SIZE_NORMAL:
            default:
                textSize = WebSettings.TextSize.NORMAL;
                break;
        }
        webView.getSettings().setTextSize(textSize);
    }


    @Override
    public void onConfigurationChanged(Configuration config) {
        super.onConfigurationChanged(config);
        switch (config.orientation) {
            case Configuration.ORIENTATION_LANDSCAPE:
                activity.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FORCE_NOT_FULLSCREEN);
                activity.getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
                break;
            case Configuration.ORIENTATION_PORTRAIT:
                activity.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
                activity.getWindow().addFlags(WindowManager.LayoutParams.FLAG_FORCE_NOT_FULLSCREEN);
                break;
        }
    }


}
