package dc.android.libs.browser;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

/**
 * @author senrsl
 * @ClassName: BaseBrowserManager
 * @Package: dc.android.libs.browser
 * @CreateTime: 2018/9/29 下午3:07
 */
public class BaseBrowserManager {
    protected Context ctx;
    protected TextView tvTitle;
    protected ProgressBar progressBar;

    protected IBaseBrowserManager.LongClickCallback cbLong;


    public void init(Context ctx, TextView tvTitle, ProgressBar progressBar) {
        this.ctx = ctx;
        this.tvTitle = tvTitle;
        this.progressBar = progressBar;
    }


    //使用外部浏览器打开
    public void openInBrowser(String uri) {
        Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(uri));
        ctx.startActivity(browserIntent);
    }


    protected boolean clickLong() {
        return false;
    }

    protected View.OnLongClickListener listenerClickLong = v -> clickLong();
}
