/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.browser.tbs;

import android.content.Context;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebView;
import dc.android.base.domain.KeyValueBean;
import dc.android.libs.browser.BaseJavascriptFunction;
import dc.android.libs.browser.BrowserContext;
import dc.android.libs.browser.IBaseBrowserManager;
import dc.android.libs.browser.tbs.BaseTbsManagerImpl;
import dc.android.libs.browser.tbs.ITbsManager;
import dc.android.libs.browser.tbs.TbsDownloadListener;
import dc.android.libs.browser.tbs.TbsWebChromeClient;
import dc.android.libs.browser.tbs.TbsWebView;
import dc.android.libs.browser.tbs.TbsWebViewClient;
import java.util.List;

public class TbsManagerImpl<T extends TbsWebView>
extends BaseTbsManagerImpl
implements ITbsManager<T> {
    private TbsWebView webView;

    @Override
    public void init(Context ctx, TextView tvTitle, ProgressBar progressBar, T webView) {
        super.init(ctx, tvTitle, progressBar);
        this.webView = webView;
    }

    @Override
    public void initSettings() {
        WebSettings webSetting = this.webView.getSettings();
        webSetting.setAllowFileAccess(true);
        webSetting.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        webSetting.setSupportZoom(true);
        webSetting.setBuiltInZoomControls(true);
        webSetting.setUseWideViewPort(true);
        webSetting.setSupportMultipleWindows(false);
        webSetting.setAppCacheEnabled(true);
        webSetting.setDomStorageEnabled(true);
        webSetting.setJavaScriptEnabled(true);
        webSetting.setJavaScriptCanOpenWindowsAutomatically(true);
        webSetting.setGeolocationEnabled(true);
        webSetting.setAppCacheMaxSize(Long.MAX_VALUE);
        webSetting.setAppCachePath(this.ctx.getDir("appcache", 0).getPath());
        webSetting.setDatabasePath(this.ctx.getDir("databases", 0).getPath());
        webSetting.setGeolocationDatabasePath(this.ctx.getDir("geolocation", 0).getPath());
        webSetting.setPluginState(WebSettings.PluginState.ON_DEMAND);
        webSetting.setCacheMode(2);
        this.webView.addAgent(BrowserContext.BROWSER_AGENT);
        this.webView.setWebChromeClient(new TbsWebChromeClient(this.ctx, this.progressBar));
        this.webView.setWebViewClient(new TbsWebViewClient(this.tvTitle, this.progressBar));
        this.webView.setOnLongClickListener(this.listenerClickLong);
        this.webView.setDownloadListener(new TbsDownloadListener());
    }

    @Override
    public void setJavascript(BaseJavascriptFunction function, String exploreName) {
        this.webView.addJavascriptInterface(function, exploreName);
    }

    @Override
    public void openInBrowser(String uri) {
        super.openInBrowser(uri);
    }

    @Override
    public void syncCookie(List<KeyValueBean> list) {
        super.syncTbsCookie(list);
    }

    @Override
    public void reload() {
        this.webView.reload();
    }

    @Override
    public boolean back() {
        if (!this.webView.canGoBack()) {
            return false;
        }
        this.webView.goBack();
        return true;
    }

    @Override
    public void destroy() {
        if (null == this.webView) {
            return;
        }
        this.webView.stopLoading();
        this.webView.destroy();
    }

    @Override
    public void setLongClickCallback(IBaseBrowserManager.LongClickCallback cb) {
        this.cbLong = cb;
    }

    @Override
    protected boolean clickLong() {
        WebView.HitTestResult result = this.webView.getHitTestResult();
        if (result.getType() == 5) {
            String uri = result.getExtra();
            if (null != this.cbLong) {
                this.cbLong.onProcess(uri);
            }
        }
        return super.clickLong();
    }
}

