/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.browser.blink;

import android.app.Activity;
import android.content.Context;
import android.os.Message;
import android.support.annotation.Nullable;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;

public class BlinkWebChromeClient
extends WebChromeClient {
    private Context ctx;
    private WebView webView;
    private ProgressBar progressBar;
    private View mCustomView;
    private FrameLayout mFrameLayout;
    private RelativeLayout layoutTitle;
    private View layoutBar;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;

    public BlinkWebChromeClient(Context ctx, WebView webView, ProgressBar progressBar) {
        this.ctx = ctx;
        this.webView = webView;
        this.progressBar = progressBar;
    }

    public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
        WebView newView = new WebView(view.getContext());
        newView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return false;
            }
        });
        WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
        transport.setWebView(view);
        resultMsg.sendToTarget();
        return true;
    }

    public void onProgressChanged(WebView view, int progress) {
        super.onProgressChanged(view, progress);
        if (null != this.progressBar) {
            this.progressBar.setProgress(progress);
        }
    }

    @Nullable
    public View getVideoLoadingProgressView() {
        return super.getVideoLoadingProgressView();
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        super.onShowCustomView(view, callback);
        if (this.mCustomView != null) {
            callback.onCustomViewHidden();
            return;
        }
        this.mCustomView = view;
        this.mFrameLayout = (FrameLayout)this.webView.getParent();
        this.layoutTitle = (RelativeLayout)((RelativeLayout)this.mFrameLayout.getParent()).getChildAt(0);
        this.layoutTitle.setVisibility(8);
        this.layoutBar = ((LinearLayout)this.mFrameLayout.getParent().getParent().getParent()).getChildAt(0);
        this.layoutBar.setVisibility(8);
        this.mFrameLayout.addView(this.mCustomView);
        this.mCustomViewCallback = callback;
        this.webView.setVisibility(8);
        this.getActivity().setRequestedOrientation(0);
    }

    public void onHideCustomView() {
        this.webView.setVisibility(0);
        this.layoutTitle.setVisibility(0);
        this.layoutBar.setVisibility(0);
        if (this.mCustomView == null) {
            return;
        }
        this.mCustomView.setVisibility(8);
        this.mFrameLayout.removeView(this.mCustomView);
        this.mCustomViewCallback.onCustomViewHidden();
        this.mCustomView = null;
        this.getActivity().setRequestedOrientation(1);
        super.onHideCustomView();
    }

    private Activity getActivity() {
        return (Activity)this.ctx;
    }
}

