/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.browser.blink;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import dc.android.libs.browser.BaseBrowserFragment;
import dc.android.libs.browser.R;
import dc.android.libs.browser.blink.BlinkManagerImpl;
import dc.android.libs.browser.blink.BlinkWebView;
import dc.common.Logger;

public class BlinkFragment
extends BaseBrowserFragment {
    private BlinkWebView webView;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_web_blink, container, false);
        return view;
    }

    protected void inflatView() {
        super.inflatView();
        this.webView = (BlinkWebView)((Object)this.findView());
    }

    @Override
    protected void initData() {
        this.browserManager = new BlinkManagerImpl();
        this.browserManager.init((Context)this.activity, this.tvTitle, this.progressBar, this.webView);
        super.initData();
    }

    @Override
    protected void load(String url) {
        this.webView.loadUrl(url);
    }

    @Override
    public String getUri() {
        Logger.w((Object[])new Object[]{this.webView.getUrl(), this.webView.getOriginalUrl()});
        return this.webView.getUrl();
    }

    @Override
    public void setFontSize(int sizeLevel) {
        WebSettings.TextSize textSize;
        switch (sizeLevel) {
            case 0: {
                textSize = WebSettings.TextSize.SMALLER;
                break;
            }
            case 2: {
                textSize = WebSettings.TextSize.LARGER;
                break;
            }
            case 3: {
                textSize = WebSettings.TextSize.LARGEST;
                break;
            }
            default: {
                textSize = WebSettings.TextSize.NORMAL;
            }
        }
        this.webView.getSettings().setTextSize(textSize);
    }

    public void onConfigurationChanged(Configuration config) {
        super.onConfigurationChanged(config);
        switch (config.orientation) {
            case 2: {
                this.activity.getWindow().clearFlags(2048);
                this.activity.getWindow().addFlags(1024);
                break;
            }
            case 1: {
                this.activity.getWindow().clearFlags(1024);
                this.activity.getWindow().addFlags(2048);
            }
        }
    }
}

