package dc.android.libs.browser.tbs;

import dc.android.libs.browser.BuildConfig;
import com.tencent.smtt.sdk.QbSdk;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebView;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;

/**
 * @author senrsl
 * @ClassName: TbsWebView
 * @Package: dc.android.libs.browser.tbs
 * @CreateTime: 2018/9/29 下午4:09
 */
public class TbsWebView extends WebView {


    public TbsWebView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        getView().setClickable(true);
    }

    @SuppressLint("SetJavaScriptEnabled")
    public void initSettings() {
        WebSettings webSetting = this.getSettings();
        webSetting.setJavaScriptEnabled(true);
        webSetting.setJavaScriptCanOpenWindowsAutomatically(true);
        webSetting.setAllowFileAccess(true);
        webSetting.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        webSetting.setSupportZoom(true);
        webSetting.setBuiltInZoomControls(true);
        webSetting.setUseWideViewPort(true);
        webSetting.setSupportMultipleWindows(true);
        // webSetting.setLoadWithOverviewMode(true);
        webSetting.setAppCacheEnabled(true);
        // webSetting.setDatabaseEnabled(true);
        webSetting.setDomStorageEnabled(true);
        webSetting.setGeolocationEnabled(true);
        webSetting.setAppCacheMaxSize(Long.MAX_VALUE);
        // webSetting.setPageCacheCapacity(IX5WebSettings.DEFAULT_CACHE_CAPACITY);
        webSetting.setPluginState(WebSettings.PluginState.ON_DEMAND);
        // webSetting.setRenderPriority(WebSettings.RenderPriority.HIGH);
        webSetting.setCacheMode(WebSettings.LOAD_NO_CACHE);

        // this.getSettingsExtension().setPageCacheCapacity(IX5WebSettings.DEFAULT_CACHE_CAPACITY);//extension
        // settings 的设计
    }

    public WebSettings getWebSettings() {
        return getSettings();
    }

    public void addAgent(String agent) {
        WebSettings webSettings = getSettings();
        webSettings.setUserAgentString(webSettings.getUserAgentString() + agent);
    }

    public void setAgent(String agent) {
        getSettings().setUserAgentString(agent);
    }

    @Override
    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        if (!BuildConfig.DEBUG) return super.drawChild(canvas, child, drawingTime);
        boolean ret = super.drawChild(canvas, child, drawingTime);
        canvas.save();
        Paint paint = new Paint();
        paint.setColor(0x7fff0000);
        paint.setTextSize(24.f);
        paint.setAntiAlias(true);
        String pkgName = getContext().getPackageName();
        int pid = android.os.Process.myPid();
        if (getX5WebViewExtension() != null) {
            canvas.drawText(pkgName + " " + pid, 10, 50, paint);
            canvas.drawText(QbSdk.getTbsVersion(getContext()) + "", 10, 100, paint);
        } else {
            canvas.drawText(pkgName + " " + pid, 10, 50, paint);
            canvas.drawText("", 10, 100, paint);
        }
        canvas.drawText(Build.MANUFACTURER, 10, 150, paint);
        canvas.drawText(Build.MODEL, 10, 200, paint);
        canvas.restore();
        return ret;
    }


}
