package dc.android.libs.browser.tbs;

import java.util.List;

import dc.android.libs.browser.BaseJavascriptFunction;
import dc.android.libs.browser.BrowserContext;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebView;

import android.content.Context;
import android.widget.ProgressBar;
import android.widget.TextView;
import dc.android.base.domain.KeyValueBean;

/**
 * @author senrsl
 * @ClassName: TbsManagerImpl
 * @Package: dc.android.libs.browser.tbs
 * @CreateTime: 2018/9/29 下午4:08
 */
public class TbsManagerImpl<T extends TbsWebView> extends BaseTbsManagerImpl implements ITbsManager<T> {

    private TbsWebView webView;

    @Override
    public void init(Context ctx, TextView tvTitle, ProgressBar progressBar, T webView) {
        super.init(ctx, tvTitle, progressBar);
        this.webView = webView;
    }


    @Override
    public void initSettings() {
        WebSettings webSetting = webView.getSettings();
        webSetting.setAllowFileAccess(true);
        webSetting.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        webSetting.setSupportZoom(true);
        webSetting.setBuiltInZoomControls(true);
        webSetting.setUseWideViewPort(true);
        webSetting.setSupportMultipleWindows(false);
        // webSetting.setLoadWithOverviewMode(true);
        webSetting.setAppCacheEnabled(true);
        // webSetting.setDatabaseEnabled(true);
        webSetting.setDomStorageEnabled(true);
        webSetting.setJavaScriptEnabled(true);
        webSetting.setJavaScriptCanOpenWindowsAutomatically(true);
        webSetting.setGeolocationEnabled(true);
        webSetting.setAppCacheMaxSize(Long.MAX_VALUE);
        webSetting.setAppCachePath(ctx.getDir("appcache", 0).getPath());
        webSetting.setDatabasePath(ctx.getDir("databases", 0).getPath());
        webSetting.setGeolocationDatabasePath(ctx.getDir("geolocation", 0).getPath());
        // webSetting.setPageCacheCapacity(IX5WebSettings.DEFAULT_CACHE_CAPACITY);
        webSetting.setPluginState(WebSettings.PluginState.ON_DEMAND);
        // webSetting.setRenderPriority(WebSettings.RenderPriority.HIGH);
        webSetting.setCacheMode(WebSettings.LOAD_NO_CACHE);
        // webSetting.setPreFectch(true);

        webView.addAgent(BrowserContext.BROWSER_AGENT);
//        webView.addJavascriptInterface(new JavascriptFunction(ctx), Constants.BROWSER_JS_METHOD);

        webView.setWebChromeClient(new TbsWebChromeClient(ctx, progressBar));
//        webView.setWebChromeClient(new TbsStandWebChromeClient(ctx,webView, progressBar));
        webView.setWebViewClient(new TbsWebViewClient(tvTitle, progressBar));
        webView.setOnLongClickListener(listenerClickLong);
        webView.setDownloadListener(new TbsDownloadListener());

//        if (webView.getX5WebViewExtension() != null) {
//            Bundle data = new Bundle();
//            data.putBoolean("standardFullScreen", true);// true表示标准全屏，会调起onShowCustomView()，false表示X5全屏；不设置默认false，
//            data.putBoolean("supportLiteWnd", false);// false：关闭小窗；true：开启小窗；不设置默认true，
//            data.putInt("DefaultVideoScreen", 2);// 1：以页面内开始播放，2：以全屏开始播放；不设置默认：1
//            webView.getX5WebViewExtension().invokeMiscMethod("setVideoParams",data);
//        }
    }

    @Override
    public void setJavascript(BaseJavascriptFunction function, String exploreName) {
        webView.addJavascriptInterface(function, exploreName);
    }

    @Override
    public void openInBrowser(String uri) {
        //TODO
        super.openInBrowser(uri);
    }


    @Override
    public void syncCookie(List<KeyValueBean> list) {
        super.syncTbsCookie(list);
    }

    @Override
    public void reload() {
        webView.reload();
    }

    @Override
    public boolean back() {
        if (webView.canGoBack())
            webView.goBack();
        else
            return false;
        return true;
    }

    @Override
    public void destroy() {
        if (null == webView) return;
        webView.stopLoading();
        webView.destroy();
    }

    @Override
    public void setLongClickCallback(LongClickCallback cb) {
        cbLong = cb;
    }

    @Override
    protected boolean clickLong() {
        // 长按事件监听（注意：需要实现LongClickCallBack接口并传入对象）
        WebView.HitTestResult result = webView.getHitTestResult();//获取所点击的内容
        if (result.getType() == WebView.HitTestResult.IMAGE_TYPE) {//判断被点击的类型为图片
            String uri = result.getExtra();
//            clickLong(uri);
            if (null != cbLong) cbLong.onProcess(uri);
        }
        return super.clickLong();
    }
}
