package dc.android.libs.browser.tbs;

import dc.android.libs.browser.BaseBrowserFragment;
import dc.android.libs.browser.R;
import com.tencent.smtt.sdk.WebSettings;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import dc.common.Logger;

import static dc.android.libs.browser.BrowserContext.WEB_LEVEL_SIZE_BIG;
import static dc.android.libs.browser.BrowserContext.WEB_LEVEL_SIZE_LARGER;
import static dc.android.libs.browser.BrowserContext.WEB_LEVEL_SIZE_NORMAL;
import static dc.android.libs.browser.BrowserContext.WEB_LEVEL_SIZE_SMALL;
import static dc.android.common.CoreContext.SPLIT_COMMA;
import static dc.common.Global.EMPTY;

/**
 * @author senrsl
 * @ClassName: TbsFragment
 * @Package: dc.android.libs.browser.tbs
 * @CreateTime: 2018/12/24 3:12 PM
 */
public class TbsFragment extends BaseBrowserFragment {


    private TbsWebView webView;


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_web_tbs, container, false);
        return view;
    }

    @Override
    protected void inflatView() {
        super.inflatView();
        webView = findView();
    }

    @Override
    protected void initData() {
        browserManager = new TbsManagerImpl();
        browserManager.init(activity, tvTitle, progressBar, webView);
        super.initData();
    }

    @Override
    protected void load(String url) {
        webView.loadUrl(url);
    }

    @Override
    protected void reload() {
        webView.reload();
    }

    @Override
    public String getUri() {
        Logger.w(webView.getUrl(), webView.getOriginalUrl());
        return webView.getUrl();
    }

    @Override
    public void setFontSize(int sizeLevel) {
        WebSettings.TextSize textSize;
        switch (sizeLevel) {
            case WEB_LEVEL_SIZE_SMALL:
                textSize = WebSettings.TextSize.SMALLER;
                break;
            case WEB_LEVEL_SIZE_BIG:
                textSize = WebSettings.TextSize.LARGER;
                break;
            case WEB_LEVEL_SIZE_LARGER:
                textSize = WebSettings.TextSize.LARGEST;
                break;
            case WEB_LEVEL_SIZE_NORMAL:
            default:
                textSize = WebSettings.TextSize.NORMAL;
                break;
        }
        webView.getSettings().setTextSize(textSize);
    }

    @Override
    public void evaluateJavascript(String function, String[] arrParam, ValueCallback<String> cb) {
        super.evaluateJavascript(function, arrParam, cb);

        StringBuffer sb = new StringBuffer("javascript:");
        sb.append(function);
        sb.append("(");
        for (int i = 0; i < arrParam.length; i++)
            sb.append(i > 0 ? SPLIT_COMMA : EMPTY).append("'").append(arrParam[i]).append("'");
        sb.append(")");
        webView.evaluateJavascript(sb.toString(), new com.tencent.smtt.sdk.ValueCallback<String>() {
            @Override
            public void onReceiveValue(String s) {
                cb.onReceiveValue(s);
            }
        });
    }
}
