package dc.android.libs.browser.blink;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.os.Message;
import android.support.annotation.Nullable;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;

/**
 * @author senrsl
 * @ClassName: BlinkWebChromeClient
 * @Package: dc.android.libs.browser.blink
 * @CreateTime: 2018/9/29 下午7:14
 */
public class BlinkWebChromeClient extends WebChromeClient {

    private Context ctx;
    private WebView webView;
    private ProgressBar progressBar;

    public BlinkWebChromeClient(Context ctx, WebView webView, ProgressBar progressBar) {
        this.ctx = ctx;
        this.webView = webView;
        this.progressBar = progressBar;
    }

    @Override
    public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
        WebView newView = new WebView(view.getContext());
        newView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return false;
            }
        });
        WebView.WebViewTransport transport = (WebView.WebViewTransport) resultMsg.obj;
        transport.setWebView(view);
        resultMsg.sendToTarget();
        return true;
    }


    private View mCustomView;
    private FrameLayout mFrameLayout;// 全屏时视频加载view
    private RelativeLayout layoutTitle;//标题栏
    private View layoutBar; //bar
    private CustomViewCallback mCustomViewCallback;

    public void onProgressChanged(WebView view, int progress) {
        super.onProgressChanged(view, progress);
        if (null != progressBar) progressBar.setProgress(progress);
    }


    @Nullable
    @Override
    public View getVideoLoadingProgressView() {
        return super.getVideoLoadingProgressView();
    }

    @Override
    public void onShowCustomView(View view, CustomViewCallback callback) {
        super.onShowCustomView(view, callback);

        if (mCustomView != null) {
            callback.onCustomViewHidden();
            return;
        }
        mCustomView = view;
        mFrameLayout = (FrameLayout) webView.getParent();
        layoutTitle = (RelativeLayout) ((RelativeLayout) mFrameLayout.getParent()).getChildAt(0);
        layoutTitle.setVisibility(View.GONE);
        layoutBar = ((LinearLayout) mFrameLayout.getParent().getParent().getParent()).getChildAt(0);
        layoutBar.setVisibility(View.GONE);
        mFrameLayout.addView(mCustomView);
        mCustomViewCallback = callback;
        webView.setVisibility(View.GONE);
        getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
    }

    @Override
    public void onHideCustomView() {
        webView.setVisibility(View.VISIBLE);
        layoutTitle.setVisibility(View.VISIBLE);
        layoutBar.setVisibility(View.VISIBLE);
        if (mCustomView == null) return;
        mCustomView.setVisibility(View.GONE);
        mFrameLayout.removeView(mCustomView);
        mCustomViewCallback.onCustomViewHidden();
        mCustomView = null;
        getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        super.onHideCustomView();
    }

    private Activity getActivity() {
        return ((Activity) ctx);
    }
}
