package dc.android.libs.browser;

import java.util.List;

import android.content.Context;
import android.widget.ProgressBar;
import android.widget.TextView;
import dc.android.base.domain.KeyValueBean;

/**
 * @author senrsl
 * @ClassName: IBrowserManager
 * @Package: dc.android.libs.browser
 * @CreateTime: 2018/9/29 下午3:09
 */
public interface IBaseBrowserManager<T> {

    void init(Context ctx, TextView tvTitle, ProgressBar progressBar, T webView);

    void initSettings();

    void setJavascript(BaseJavascriptFunction function, String exploreName);

//    void setCookie();
    void syncCookie(List<KeyValueBean> list);

    void reload();

    boolean back();

    void destroy();

    void openInBrowser(String uri);


    void setLongClickCallback(LongClickCallback cb);

    interface LongClickCallback{
        void onProcess(String uri);
    }

}
