/*
 * Decompiled with CFR 0.152.
 */
package com.zzhoujay.html.style;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.Layout;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.ReplacementSpan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ZCodeBlockSpan
extends ReplacementSpan
implements LeadingMarginSpan,
LineHeightSpan {
    private static final int DEFAULT_BACKGROUND_COLOR = Color.parseColor((String)"#F4F4F5");
    private static final int DEFAULT_TEXT_COLOR = Color.parseColor((String)"#24292E");
    private static final int RADIUS = 10;
    private static final int MARGIN = 5;
    private static final int PADDING = 16;
    private static final int PADDING_START = 20;
    private static final float TEXT_SIZE_SCALE = 0.92f;
    private int mWidth;
    private Drawable mBackground;
    private int mTextColor;
    private int mBaseline;
    private int mLineHeight;
    private List<CharSequence> mLines;

    public ZCodeBlockSpan(int backgroundColor, int textColor, CharSequence lines) {
        GradientDrawable g = new GradientDrawable();
        g.setColor(backgroundColor);
        g.setCornerRadius(10.0f);
        this.mBackground = g;
        this.mLines = this.split(lines);
        this.mTextColor = textColor;
    }

    public ZCodeBlockSpan(CharSequence lines) {
        this(DEFAULT_BACKGROUND_COLOR, DEFAULT_TEXT_COLOR, lines);
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        return this.mWidth;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        float size = paint.getTextSize();
        paint.setTextSize(size * 0.92f);
        paint.setTypeface(Typeface.MONOSPACE);
        int height = this.mLines.size() * this.mLineHeight;
        this.mBackground.setBounds((int)x + 5, top + 5, (int)x + this.mWidth - 5, top + height + 32 - 5);
        this.mBackground.draw(canvas);
        canvas.save();
        canvas.clipRect(x + 20.0f, (float)(top + 16), x + (float)this.mWidth - 20.0f, (float)(top + height + 16));
        int color = paint.getColor();
        paint.setColor(this.mTextColor);
        int i = this.mBaseline + 16 + top;
        for (CharSequence mLine : this.mLines) {
            canvas.drawText(mLine, 0, mLine.length(), x + 20.0f, (float)i, paint);
            i += this.mLineHeight;
        }
        paint.setTextSize(size);
        paint.setColor(color);
        canvas.restore();
    }

    public void chooseHeight(CharSequence text, int start, int end, int spanstartv, int v, Paint.FontMetricsInt fm) {
        int num = this.mLines.size();
        this.mLineHeight = fm.bottom - fm.top;
        this.mBaseline = -fm.top;
        fm.ascent = fm.top;
        fm.bottom += (num - 1) * this.mLineHeight + 32;
        fm.descent = fm.bottom;
    }

    public int getLeadingMargin(boolean first) {
        return 0;
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        this.mWidth = layout.getWidth();
    }

    private List<CharSequence> split(CharSequence cs) {
        int start = 0;
        int end = cs.length();
        if (start >= end) {
            return Collections.emptyList();
        }
        while (cs.charAt(start) == '\n' && start < end) {
            ++start;
        }
        while (cs.charAt(end - 1) == '\n' && start < end) {
            --end;
        }
        if (start >= end) {
            return Collections.emptyList();
        }
        ArrayList<CharSequence> list = new ArrayList<CharSequence>();
        int length = cs.length();
        int last = 0;
        for (int i = 0; i < length; ++i) {
            char c = cs.charAt(i);
            if (c != '\n') continue;
            list.add(cs.subSequence(last, i));
            last = i + 1;
        }
        if (last < length) {
            list.add(cs.subSequence(last, length));
        }
        return list;
    }
}

