/*
 * Decompiled with CFR 0.152.
 */
package com.zys.brokenview;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import com.zys.brokenview.Utils;

class Piece
implements Comparable {
    Bitmap bitmap;
    Matrix matrix;
    private int x;
    private int y;
    private int rotateX;
    private int rotateY;
    private float angle;
    private float speed;
    private int shadow;
    private int limitY;

    public Piece(int x, int y, Bitmap bitmap, int shadow) {
        this.bitmap = bitmap;
        this.x = x;
        this.y = y;
        this.shadow = shadow;
        if (bitmap != null) {
            this.matrix = new Matrix();
            this.matrix.postTranslate((float)x, (float)y);
            this.speed = Utils.nextFloat(1.0f, 4.0f);
            this.rotateX = Utils.nextInt(bitmap.getWidth());
            this.rotateY = Utils.nextInt(bitmap.getHeight());
            this.angle = Utils.nextFloat(0.6f) * (float)(Utils.nextBoolean() ? 1 : -1);
            int bitmapW = bitmap.getWidth();
            int bitmapH = bitmap.getHeight();
            this.limitY = bitmapW > bitmapH ? bitmapW : bitmapH;
            this.limitY += Utils.screenHeight;
        }
    }

    public int compareTo(Object another) {
        return this.shadow - ((Piece)another).shadow;
    }

    public boolean advance(float fraction) {
        float s = (float)Math.pow(fraction * 1.1226f, 2.0) * 8.0f * this.speed;
        float zy = (float)this.y + s * (float)Utils.screenHeight / 10.0f;
        float r = fraction * fraction;
        this.matrix.reset();
        this.matrix.setRotate(this.angle * r * 360.0f, (float)this.rotateX, (float)this.rotateY);
        this.matrix.postTranslate((float)this.x, zy);
        return zy <= (float)this.limitY;
    }
}

