/*
 * Decompiled with CFR 0.152.
 */
package com.zys.brokenview;

import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import java.util.ArrayList;

class LinePath
extends Path {
    private Point endPoint;
    private float startLength;
    private boolean straight;
    public ArrayList<Point> points;

    public LinePath() {
        this.points = new ArrayList();
        this.startLength = -1.0f;
        this.endPoint = new Point();
    }

    public LinePath(LinePath p) {
        super((Path)p);
        this.points = (ArrayList)p.points.clone();
        this.startLength = p.getStartLength();
        this.endPoint = new Point(p.getEndPoint());
    }

    public void setEndPoint(Point endPoint) {
        this.endPoint = endPoint;
    }

    public void setEndPoint(int endX, int endY) {
        this.endPoint.set(endX, endY);
    }

    public Point getEndPoint() {
        return this.endPoint;
    }

    public int getEndX() {
        return this.endPoint.x;
    }

    public int getEndY() {
        return this.endPoint.y;
    }

    public boolean isStraight() {
        return this.straight;
    }

    public void setStraight(boolean straight) {
        this.straight = straight;
    }

    public float getStartLength() {
        return this.startLength;
    }

    public void setStartLength(float startLength) {
        this.startLength = startLength;
    }

    public void lineToEnd() {
        this.lineTo(this.endPoint.x, this.endPoint.y);
    }

    public void obtainEndPoint(int angleRandom, int[] angleBase, Rect r) {
        float gradient = -((float)Math.tan(Math.toRadians(angleRandom)));
        int endX = 0;
        int endY = 0;
        if (angleRandom >= 0 && angleRandom < 90) {
            if (angleRandom < angleBase[0]) {
                endX = r.right;
                endY = (int)((float)endX * gradient);
            } else if (angleRandom > angleBase[0]) {
                endY = r.top;
                endX = (int)((float)endY / gradient);
            } else if (angleRandom == angleBase[0]) {
                endY = r.top;
                endX = r.right;
            }
        } else if (angleRandom > 90 && angleRandom <= 180) {
            if (180 - angleRandom < angleBase[1]) {
                endX = r.left;
                endY = (int)((float)endX * gradient);
            } else if (180 - angleRandom > angleBase[1]) {
                endY = r.top;
                endX = (int)((float)endY / gradient);
            } else if (180 - angleRandom == angleBase[1]) {
                endY = r.top;
                endX = r.left;
            }
        } else if (angleRandom > 180 && angleRandom < 270) {
            if (angleRandom - 180 < angleBase[2]) {
                endX = r.left;
                endY = (int)((float)endX * gradient);
            } else if (angleRandom - 180 > angleBase[2]) {
                endY = r.bottom;
                endX = (int)((float)endY / gradient);
            } else if (angleRandom - 180 == angleBase[2]) {
                endY = r.bottom;
                endX = r.left;
            }
        } else if (angleRandom > 270 && angleRandom < 360) {
            if (360 - angleRandom < angleBase[3]) {
                endX = r.right;
                endY = (int)((float)endX * gradient);
            } else if (360 - angleRandom > angleBase[3]) {
                endY = r.bottom;
                endX = (int)((float)endY / gradient);
            } else if (360 - angleRandom == angleBase[3]) {
                endY = r.bottom;
                endX = r.right;
            }
        } else if (angleRandom == 90) {
            endX = 0;
            endY = r.top;
        } else if (angleRandom == 270) {
            endX = 0;
            endY = r.bottom;
        }
        this.endPoint.set(endX, endY);
    }
}

