/*
 * Decompiled with CFR 0.152.
 */
package com.zys.brokenview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import com.zys.brokenview.BrokenAnimator;
import com.zys.brokenview.BrokenCallback;
import com.zys.brokenview.BrokenConfig;
import com.zys.brokenview.Utils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;

public class BrokenView
extends View {
    private HashMap<View, BrokenAnimator> animMap;
    private LinkedList<BrokenAnimator> animList;
    private BrokenCallback callBack;
    private boolean enable;

    public BrokenView(Context context) {
        this(context, null);
    }

    public BrokenView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BrokenView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayerType(2, null);
        this.enable = true;
        this.animMap = new HashMap();
        this.animList = new LinkedList();
    }

    protected void onDraw(Canvas canvas) {
        ListIterator<BrokenAnimator> iterator = this.animList.listIterator(this.animList.size());
        while (iterator.hasPrevious()) {
            iterator.previous().draw(canvas);
        }
    }

    public BrokenAnimator getAnimator(View view) {
        BrokenAnimator bAnim = this.animMap.get(view);
        if (bAnim != null && bAnim.getStage() != 3) {
            return bAnim;
        }
        return null;
    }

    public BrokenAnimator createAnimator(final View view, Point point, BrokenConfig config) {
        Bitmap bitmap = Utils.convertViewToBitmap(view);
        if (bitmap == null) {
            return null;
        }
        BrokenAnimator bAnim = new BrokenAnimator(this, view, bitmap, point, config);
        bAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationRepeat(Animator animation) {
                super.onAnimationRepeat(animation);
                BrokenAnimator bAnim = (BrokenAnimator)animation;
                bAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        BrokenAnimator bA = (BrokenAnimator)animation;
                        bA.setInterpolator((TimeInterpolator)new LinearInterpolator());
                        bA.setStage(2);
                        bA.setFallingDuration();
                        BrokenView.this.onBrokenFalling(view);
                        bA.removeUpdateListener(this);
                    }
                });
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                BrokenAnimator bAnim = (BrokenAnimator)animation;
                BrokenView.this.animMap.remove(view);
                BrokenView.this.animList.remove((Object)bAnim);
                if (bAnim.getStage() == 1) {
                    BrokenView.this.onBrokenCancelEnd(view);
                } else if (bAnim.getStage() == 2) {
                    BrokenView.this.onBrokenFallingEnd(view);
                }
            }
        });
        this.animList.addLast(bAnim);
        this.animMap.put(view, bAnim);
        return bAnim;
    }

    public static BrokenView add2Window(Activity activity) {
        ViewGroup rootView = (ViewGroup)activity.findViewById(0x1020002);
        BrokenView brokenView = new BrokenView((Context)activity);
        rootView.addView((View)brokenView, new ViewGroup.LayoutParams(-1, -1));
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        Utils.screenWidth = dm.widthPixels;
        Utils.screenHeight = dm.heightPixels;
        return brokenView;
    }

    public void reset() {
        ListIterator iterator = this.animList.listIterator();
        while (iterator.hasNext()) {
            BrokenAnimator bAnim = (BrokenAnimator)((Object)iterator.next());
            bAnim.removeAllListeners();
            bAnim.cancel();
        }
        this.animList.clear();
        this.animMap.clear();
        this.invalidate();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setCallback(BrokenCallback c) {
        this.callBack = c;
    }

    protected void onBrokenCancel(View v) {
        if (this.callBack != null) {
            this.callBack.onCancel(v);
        }
    }

    protected void onBrokenStart(View v) {
        if (this.callBack != null) {
            this.callBack.onStart(v);
        }
    }

    protected void onBrokenCancelEnd(View v) {
        if (this.callBack != null) {
            this.callBack.onCancelEnd(v);
        }
    }

    protected void onBrokenFallingEnd(View v) {
        if (this.callBack != null) {
            this.callBack.onFallingEnd(v);
        }
    }

    protected void onBrokenRestart(View v) {
        if (this.callBack != null) {
            this.callBack.onRestart(v);
        }
    }

    protected void onBrokenFalling(View v) {
        v.setVisibility(4);
        if (this.callBack != null) {
            this.callBack.onFalling(v);
        }
    }
}

