/*
 * Decompiled with CFR 0.152.
 */
package com.zys.brokenview;

import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Region;
import android.view.MotionEvent;
import android.view.View;
import com.zys.brokenview.BrokenAnimator;
import com.zys.brokenview.BrokenConfig;
import com.zys.brokenview.BrokenView;

public class BrokenTouchListener
implements View.OnTouchListener {
    private BrokenAnimator brokenAnim;
    private BrokenView brokenView;
    private BrokenConfig config;

    private BrokenTouchListener(Builder builder) {
        this.brokenView = builder.brokenView;
        this.config = builder.config;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.brokenView.isEnable()) {
            switch (event.getAction()) {
                case 0: {
                    if (this.config.childView != null) {
                        this.config.region = new Region(this.config.childView.getLeft(), this.config.childView.getTop(), this.config.childView.getRight(), this.config.childView.getBottom());
                    }
                    if (this.config.region == null || this.config.region.contains((int)event.getX(), (int)event.getY())) {
                        Point point = new Point((int)event.getRawX(), (int)event.getRawY());
                        this.brokenAnim = this.brokenView.getAnimator(v);
                        if (this.brokenAnim == null) {
                            this.brokenAnim = this.brokenView.createAnimator(v, point, this.config);
                        }
                        if (this.brokenAnim == null) {
                            return true;
                        }
                        if (!this.brokenAnim.isStarted()) {
                            this.brokenAnim.start();
                            this.brokenView.onBrokenStart(v);
                        } else if (this.brokenAnim.doReverse()) {
                            this.brokenView.onBrokenRestart(v);
                        }
                        v.getParent().requestDisallowInterceptTouchEvent(true);
                        break;
                    }
                    return false;
                }
                case 1: {
                    this.brokenAnim = this.brokenView.getAnimator(v);
                    if (this.brokenAnim == null || !this.brokenAnim.isStarted() || !this.brokenAnim.doReverse()) break;
                    this.brokenView.onBrokenCancel(v);
                }
            }
            return true;
        }
        return false;
    }

    public static class Builder {
        private BrokenConfig config;
        private BrokenView brokenView;

        public Builder(BrokenView brokenView) {
            this.brokenView = brokenView;
            this.config = new BrokenConfig();
        }

        public Builder setComplexity(int complexity) {
            if (complexity < 6) {
                complexity = 6;
            } else if (complexity > 20) {
                complexity = 20;
            }
            this.config.complexity = complexity;
            return this;
        }

        public Builder setBreakDuration(int breakDuration) {
            if (breakDuration < 200) {
                breakDuration = 200;
            }
            this.config.breakDuration = breakDuration;
            return this;
        }

        public Builder setFallDuration(int fallDuration) {
            if (fallDuration < 200) {
                fallDuration = 200;
            }
            this.config.fallDuration = fallDuration;
            return this;
        }

        public Builder setCircleRiftsRadius(int radius) {
            if (radius < 20 && radius != 0) {
                radius = 20;
            }
            this.config.circleRiftsRadius = radius;
            return this;
        }

        public Builder setEnableArea(Region region) {
            this.config.region = region;
            this.config.childView = null;
            return this;
        }

        public Builder setEnableArea(View childView) {
            this.config.childView = childView;
            this.config.region = null;
            return this;
        }

        public Builder setPaint(Paint paint) {
            this.config.paint = paint;
            return this;
        }

        public BrokenTouchListener build() {
            return new BrokenTouchListener(this);
        }
    }
}

