/*
 * Decompiled with CFR 0.152.
 */
package com.zys.brokenview;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import com.zys.brokenview.BrokenConfig;
import com.zys.brokenview.BrokenView;
import com.zys.brokenview.LinePath;
import com.zys.brokenview.Piece;
import com.zys.brokenview.Utils;
import java.util.ArrayList;
import java.util.Arrays;

class BrokenAnimator
extends ValueAnimator {
    private final int SEGMENT;
    static final int STAGE_BREAKING = 1;
    static final int STAGE_FALLING = 2;
    static final int STAGE_EARLYEND = 3;
    static final int STAGE_TEST = 0;
    private int stage = 1;
    private BrokenView mBrokenView;
    private View mView;
    private BrokenConfig mConfig;
    private Bitmap mBitmap;
    private Point mTouchPoint;
    private Paint onDrawPaint;
    private Path onDrawPath;
    private PathMeasure onDrawPM;
    private boolean canReverse = false;
    private boolean bPressed = true;
    private LinePath[] lineRifts;
    private Path[] circleRifts;
    private int[] circleWidth;
    private ArrayList<Path> pathArray;
    private Piece[] pieces;
    private int offsetX;
    private int offsetY;

    public BrokenAnimator(BrokenView brokenView, View view, Bitmap bitmap, Point point, BrokenConfig config) {
        this.mBrokenView = brokenView;
        this.mView = view;
        this.mBitmap = bitmap;
        this.mTouchPoint = point;
        this.mConfig = config;
        this.pathArray = new ArrayList();
        this.onDrawPath = new Path();
        this.onDrawPM = new PathMeasure();
        this.lineRifts = new LinePath[this.mConfig.complexity];
        this.circleRifts = new Path[this.mConfig.complexity];
        this.circleWidth = new int[this.mConfig.complexity];
        this.SEGMENT = this.mConfig.circleRiftsRadius;
        Rect r = new Rect();
        this.mView.getGlobalVisibleRect(r);
        this.offsetX = this.mTouchPoint.x - r.left;
        this.offsetY = this.mTouchPoint.y - r.top;
        r.offset(-this.mTouchPoint.x, -this.mTouchPoint.y);
        Rect brokenViewR = new Rect();
        this.mBrokenView.getGlobalVisibleRect(brokenViewR);
        this.mTouchPoint.x -= brokenViewR.left;
        this.mTouchPoint.y -= brokenViewR.top;
        this.buildBrokenLines(r);
        this.buildBrokenAreas(r);
        this.buildPieces();
        this.buildPaintShader();
        this.warpStraightLines();
        this.setFloatValues(new float[]{0.0f, 1.0f});
        this.setInterpolator((TimeInterpolator)new AccelerateInterpolator(2.0f));
        this.setDuration(this.mConfig.breakDuration);
    }

    private void buildBrokenLines(Rect r) {
        LinePath[] baseLines = new LinePath[this.mConfig.complexity];
        this.buildBaselines(baseLines, r);
        PathMeasure pmTemp = new PathMeasure();
        for (int i = 0; i < this.mConfig.complexity; ++i) {
            this.lineRifts[i] = new LinePath();
            this.lineRifts[i].moveTo(0.0f, 0.0f);
            this.lineRifts[i].setEndPoint(baseLines[i].getEndPoint());
            pmTemp.setPath((Path)baseLines[i], false);
            float length = pmTemp.getLength();
            int THRESHOLD = this.SEGMENT + this.SEGMENT / 2;
            if (length > (float)Utils.dp2px(THRESHOLD)) {
                this.lineRifts[i].setStraight(false);
                float[] pos = new float[2];
                pmTemp.getPosTan((float)Utils.dp2px(this.SEGMENT), pos, null);
                this.lineRifts[i].lineTo(pos[0], pos[1]);
                this.lineRifts[i].points.add(new Point((int)pos[0], (int)pos[1]));
                int step = Utils.dp2px(THRESHOLD);
                do {
                    pmTemp.getPosTan((float)step, pos, null);
                    int xRandom = (int)(pos[0] + (float)Utils.nextInt(-Utils.dp2px(3), Utils.dp2px(2)));
                    int yRandom = (int)(pos[1] + (float)Utils.nextInt(-Utils.dp2px(2), Utils.dp2px(3)));
                    this.lineRifts[i].lineTo(xRandom, yRandom);
                    this.lineRifts[i].points.add(new Point(xRandom, yRandom));
                } while ((float)(step += Utils.dp2px(this.SEGMENT)) < length);
                this.lineRifts[i].lineToEnd();
            } else {
                this.lineRifts[i] = baseLines[i];
                this.lineRifts[i].setStraight(true);
            }
            this.lineRifts[i].points.add(this.lineRifts[i].getEndPoint());
        }
    }

    private void buildBaselines(LinePath[] baseLines, Rect r) {
        for (int i = 0; i < this.mConfig.complexity; ++i) {
            baseLines[i] = new LinePath();
            baseLines[i].moveTo(0.0f, 0.0f);
        }
        this.buildFirstLine(baseLines[0], r);
        int angle = (int)Math.toDegrees(Math.atan((float)(-baseLines[0].getEndY()) / (float)baseLines[0].getEndX()));
        int[] angleBase = new int[]{(int)Math.toDegrees(Math.atan((float)(-r.top) / (float)r.right)), (int)Math.toDegrees(Math.atan((float)(-r.top) / (float)(-r.left))), (int)Math.toDegrees(Math.atan((float)r.bottom / (float)(-r.left))), (int)Math.toDegrees(Math.atan((float)r.bottom / (float)r.right))};
        if (baseLines[0].getEndX() < 0) {
            angle += 180;
        } else if (baseLines[0].getEndX() > 0 && baseLines[0].getEndY() > 0) {
            angle += 360;
        }
        int range = 360 / this.mConfig.complexity / 3;
        for (int i = 1; i < this.mConfig.complexity; ++i) {
            int angleRandom;
            if ((angle += 360 / this.mConfig.complexity) >= 360) {
                angle -= 360;
            }
            if ((angleRandom = angle + Utils.nextInt(-range, range)) >= 360) {
                angleRandom -= 360;
            } else if (angleRandom < 0) {
                angleRandom += 360;
            }
            baseLines[i].obtainEndPoint(angleRandom, angleBase, r);
            baseLines[i].lineToEnd();
        }
    }

    private void buildFirstLine(LinePath path, Rect r) {
        int[] range = new int[]{-r.left, -r.top, r.right, r.bottom};
        int max = -1;
        int maxId = 0;
        for (int i = 0; i < 4; ++i) {
            if (range[i] <= max) continue;
            max = range[i];
            maxId = i;
        }
        switch (maxId) {
            case 0: {
                path.setEndPoint(r.left, Utils.nextInt(r.height()) + r.top);
                break;
            }
            case 1: {
                path.setEndPoint(Utils.nextInt(r.width()) + r.left, r.top);
                break;
            }
            case 2: {
                path.setEndPoint(r.right, Utils.nextInt(r.height()) + r.top);
                break;
            }
            case 3: {
                path.setEndPoint(Utils.nextInt(r.width()) + r.left, r.bottom);
            }
        }
        path.lineToEnd();
    }

    private void buildBrokenAreas(Rect r) {
        int SEGMENT_LESS = this.SEGMENT * 7 / 9;
        int START_LENGTH = (int)((double)this.SEGMENT * 1.1);
        float linkLen = 0.0f;
        int repeat = 0;
        PathMeasure pmNow = new PathMeasure();
        PathMeasure pmPre = new PathMeasure();
        for (int i = 0; i < this.mConfig.complexity; ++i) {
            this.lineRifts[i].setStartLength(Utils.dp2px(START_LENGTH));
            if (repeat > 0) {
                --repeat;
            } else {
                linkLen = Utils.nextInt(Utils.dp2px(SEGMENT_LESS), Utils.dp2px(this.SEGMENT));
                repeat = Utils.nextInt(3);
            }
            int iPre = i - 1 < 0 ? this.mConfig.complexity - 1 : i - 1;
            pmNow.setPath((Path)this.lineRifts[i], false);
            pmPre.setPath((Path)this.lineRifts[iPre], false);
            if (this.SEGMENT != 0 && pmNow.getLength() > linkLen && pmPre.getLength() > linkLen) {
                float[] pointNow = new float[2];
                float[] pointPre = new float[2];
                this.circleWidth[i] = Utils.nextInt(Utils.dp2px(1)) + 1;
                this.circleRifts[i] = new Path();
                pmNow.getPosTan(linkLen, pointNow, null);
                this.circleRifts[i].moveTo(pointNow[0], pointNow[1]);
                pmPre.getPosTan(linkLen, pointPre, null);
                this.circleRifts[i].lineTo(pointPre[0], pointPre[1]);
                Path pathArea = new Path();
                pmPre.getSegment(linkLen, pmPre.getLength(), pathArea, true);
                pathArea.rLineTo(0.0f, 0.0f);
                this.drawBorder(pathArea, this.lineRifts[iPre].getEndPoint(), this.lineRifts[i].points.get(this.lineRifts[i].points.size() - 1), r);
                for (int j = this.lineRifts[i].points.size() - 2; j >= 0; --j) {
                    pathArea.lineTo((float)this.lineRifts[i].points.get((int)j).x, (float)this.lineRifts[i].points.get((int)j).y);
                }
                pathArea.lineTo(pointNow[0], pointNow[1]);
                pathArea.lineTo(pointPre[0], pointPre[1]);
                pathArea.close();
                this.pathArray.add(pathArea);
                pathArea = new Path();
                pathArea.moveTo(0.0f, 0.0f);
                pathArea.lineTo(pointPre[0], pointPre[1]);
                pathArea.lineTo(pointNow[0], pointNow[1]);
                pathArea.close();
                this.pathArray.add(pathArea);
                continue;
            }
            Path pathArea = new Path((Path)this.lineRifts[iPre]);
            this.drawBorder(pathArea, this.lineRifts[iPre].getEndPoint(), this.lineRifts[i].points.get(this.lineRifts[i].points.size() - 1), r);
            for (int j = this.lineRifts[i].points.size() - 2; j >= 0; --j) {
                pathArea.lineTo((float)this.lineRifts[i].points.get((int)j).x, (float)this.lineRifts[i].points.get((int)j).y);
            }
            pathArea.close();
            this.pathArray.add(pathArea);
        }
    }

    private void buildPieces() {
        this.pieces = new Piece[this.pathArray.size()];
        Paint paint = new Paint();
        Matrix matrix = new Matrix();
        Canvas canvas = new Canvas();
        for (int i = 0; i < this.pieces.length; ++i) {
            int shadow = Utils.nextInt(Utils.dp2px(2), Utils.dp2px(9));
            Path path = this.pathArray.get(i);
            RectF r = new RectF();
            path.computeBounds(r, true);
            Bitmap pBitmap = Utils.createBitmapSafely((int)r.width() + shadow * 2, (int)r.height() + shadow * 2, Bitmap.Config.ARGB_4444, 1);
            if (pBitmap == null) {
                this.pieces[i] = new Piece(-1, -1, null, shadow);
                continue;
            }
            this.pieces[i] = new Piece((int)r.left + this.mTouchPoint.x - shadow, (int)r.top + this.mTouchPoint.y - shadow, pBitmap, shadow);
            canvas.setBitmap(this.pieces[i].bitmap);
            BitmapShader mBitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            matrix.reset();
            matrix.setTranslate(-r.left - (float)this.offsetX + (float)shadow, -r.top - (float)this.offsetY + (float)shadow);
            mBitmapShader.setLocalMatrix(matrix);
            paint.reset();
            Path offsetPath = new Path();
            offsetPath.addPath(path, -r.left + (float)shadow, -r.top + (float)shadow);
            paint.setStyle(Paint.Style.FILL);
            paint.setShadowLayer((float)shadow, 0.0f, 0.0f, -13421773);
            canvas.drawPath(offsetPath, paint);
            paint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.XOR));
            canvas.drawPath(offsetPath, paint);
            paint.setXfermode(null);
            paint.setShader((Shader)mBitmapShader);
            paint.setAlpha(204);
            canvas.drawPath(offsetPath, paint);
        }
        Arrays.sort(this.pieces);
    }

    private void buildPaintShader() {
        if (this.mConfig.paint == null) {
            this.onDrawPaint = new Paint();
            BitmapShader shader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            Matrix matrix = new Matrix();
            matrix.setTranslate((float)(-this.offsetX - 10), (float)(-this.offsetY - 7));
            shader.setLocalMatrix(matrix);
            ColorMatrix cMatrix = new ColorMatrix();
            cMatrix.set(new float[]{2.5f, 0.0f, 0.0f, 0.0f, 100.0f, 0.0f, 2.5f, 0.0f, 0.0f, 100.0f, 0.0f, 0.0f, 2.5f, 0.0f, 100.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
            this.onDrawPaint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(cMatrix));
            this.onDrawPaint.setShader((Shader)shader);
            this.onDrawPaint.setStyle(Paint.Style.FILL);
        } else {
            this.onDrawPaint = this.mConfig.paint;
        }
    }

    private void warpStraightLines() {
        PathMeasure pmTemp = new PathMeasure();
        for (int i = 0; i < this.mConfig.complexity; ++i) {
            if (!this.lineRifts[i].isStraight()) continue;
            pmTemp.setPath((Path)this.lineRifts[i], false);
            this.lineRifts[i].setStartLength(pmTemp.getLength() / 2.0f);
            float[] pos = new float[2];
            pmTemp.getPosTan(pmTemp.getLength() / 2.0f, pos, null);
            int xRandom = (int)(pos[0] + (float)Utils.nextInt(-Utils.dp2px(1), Utils.dp2px(1)));
            int yRandom = (int)(pos[1] + (float)Utils.nextInt(-Utils.dp2px(1), Utils.dp2px(1)));
            this.lineRifts[i].reset();
            this.lineRifts[i].moveTo(0.0f, 0.0f);
            this.lineRifts[i].lineTo(xRandom, yRandom);
            this.lineRifts[i].lineToEnd();
        }
    }

    public void drawBorder(Path path, Point pointStart, Point pointEnd, Rect r) {
        if (pointStart.x == r.right) {
            if (pointEnd.x == r.right) {
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            } else if (pointEnd.y == r.top) {
                path.lineTo((float)r.right, (float)r.top);
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            } else if (pointEnd.x == r.left) {
                path.lineTo((float)r.right, (float)r.top);
                path.lineTo((float)r.left, (float)r.top);
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            } else if (pointEnd.y == r.bottom) {
                path.lineTo((float)r.right, (float)r.top);
                path.lineTo((float)r.left, (float)r.top);
                path.lineTo((float)r.left, (float)r.bottom);
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            }
        } else if (pointStart.y == r.top) {
            if (pointEnd.y == r.top) {
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            } else if (pointEnd.x == r.left) {
                path.lineTo((float)r.left, (float)r.top);
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            } else if (pointEnd.y == r.bottom) {
                path.lineTo((float)r.left, (float)r.top);
                path.lineTo((float)r.left, (float)r.bottom);
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            } else if (pointEnd.x == r.right) {
                path.lineTo((float)r.left, (float)r.top);
                path.lineTo((float)r.left, (float)r.bottom);
                path.lineTo((float)r.right, (float)r.bottom);
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            }
        } else if (pointStart.x == r.left) {
            if (pointEnd.x == r.left) {
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            } else if (pointEnd.y == r.bottom) {
                path.lineTo((float)r.left, (float)r.bottom);
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            } else if (pointEnd.x == r.right) {
                path.lineTo((float)r.left, (float)r.bottom);
                path.lineTo((float)r.right, (float)r.bottom);
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            } else if (pointEnd.y == r.top) {
                path.lineTo((float)r.left, (float)r.bottom);
                path.lineTo((float)r.right, (float)r.bottom);
                path.lineTo((float)r.right, (float)r.top);
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            }
        } else if (pointStart.y == r.bottom) {
            if (pointEnd.y == r.bottom) {
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            } else if (pointEnd.x == r.right) {
                path.lineTo((float)r.right, (float)r.bottom);
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            } else if (pointEnd.y == r.top) {
                path.lineTo((float)r.right, (float)r.bottom);
                path.lineTo((float)r.right, (float)r.top);
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            } else if (pointEnd.x == r.left) {
                path.lineTo((float)r.right, (float)r.bottom);
                path.lineTo((float)r.right, (float)r.top);
                path.lineTo((float)r.left, (float)r.top);
                path.lineTo((float)pointEnd.x, (float)pointEnd.y);
            }
        }
    }

    public void setStage(int s) {
        this.stage = s;
    }

    public int getStage() {
        return this.stage;
    }

    public void setFallingDuration() {
        this.setDuration(this.mConfig.fallDuration);
    }

    public void start() {
        super.start();
        this.canReverse = true;
        this.mBrokenView.invalidate();
    }

    public boolean doReverse() {
        if (this.canReverse) {
            this.bPressed = !this.bPressed;
            this.reverse();
        }
        return this.canReverse;
    }

    public boolean draw(Canvas canvas) {
        if (!this.isStarted()) {
            return false;
        }
        float fraction = this.getAnimatedFraction();
        if (this.getStage() == 1) {
            canvas.save();
            canvas.translate((float)this.mTouchPoint.x, (float)this.mTouchPoint.y);
            for (int i = 0; i < this.mConfig.complexity; ++i) {
                this.onDrawPaint.setStyle(Paint.Style.FILL);
                this.onDrawPath.reset();
                this.onDrawPM.setPath((Path)this.lineRifts[i], false);
                float pathLength = this.onDrawPM.getLength();
                float startLength = this.lineRifts[i].getStartLength();
                float drawLength = startLength + fraction * (pathLength - startLength);
                if (drawLength > pathLength) {
                    drawLength = pathLength;
                }
                this.onDrawPM.getSegment(0.0f, drawLength, this.onDrawPath, false);
                this.onDrawPath.rLineTo(0.0f, 0.0f);
                canvas.drawPath(this.onDrawPath, this.onDrawPaint);
                if (this.SEGMENT == 0 || this.circleRifts[i] == null || !((double)fraction > 0.1)) continue;
                this.onDrawPaint.setStyle(Paint.Style.STROKE);
                float t = (fraction - 0.1f) * 2.0f;
                if (t > 1.0f) {
                    t = 1.0f;
                }
                this.onDrawPaint.setStrokeWidth((float)this.circleWidth[i] * t);
                canvas.drawPath(this.circleRifts[i], this.onDrawPaint);
            }
            if ((double)fraction > 0.8 && this.bPressed) {
                this.canReverse = false;
                this.setRepeatCount(1);
            }
            canvas.restore();
        } else if (this.getStage() == 2) {
            int piecesNum = this.pieces.length;
            for (Piece p : this.pieces) {
                if (p.bitmap != null && p.advance(fraction)) {
                    canvas.drawBitmap(p.bitmap, p.matrix, null);
                    continue;
                }
                --piecesNum;
            }
            if (piecesNum == 0) {
                this.setStage(3);
                this.mBrokenView.onBrokenFallingEnd(this.mView);
            }
        } else if (this.getStage() == 0) {
            float t = 1.0f / (float)this.pieces.length;
            int drawNum = (int)(fraction / t);
            for (int i = 0; i <= drawNum; ++i) {
                if (this.pieces[i].bitmap == null) continue;
                canvas.drawBitmap(this.pieces[i].bitmap, this.pieces[i].matrix, null);
            }
        }
        this.mBrokenView.invalidate();
        return true;
    }
}

