/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum AccountingCodeType {
    ACCOUNTSRECEIVABLE("AccountsReceivable"),
    ONACCOUNTRECEIVABLE("OnAccountReceivable"),
    CASH("Cash"),
    OTHERASSETS("OtherAssets"),
    CUSTOMERCASHONACCOUNT("CustomerCashOnAccount"),
    DEFERREDREVENUE("DeferredRevenue"),
    SALESTAXPAYABLE("SalesTaxPayable"),
    OTHERLIABILITIES("OtherLiabilities"),
    SALESREVENUE("SalesRevenue"),
    SALESDISCOUNTS("SalesDiscounts"),
    OTHERREVENUE("OtherRevenue"),
    OTHEREQUITY("OtherEquity"),
    BADDEBT("BadDebt"),
    OTHEREXPENSES("OtherExpenses"),
    UNBILLEDRECEIVABLES("UnbilledReceivables"),
    CONTRACTASSETS("ContractAssets"),
    CONTRACTLIABILITIES("ContractLiabilities"),
    ADJUSTMENTLIABILITIES("AdjustmentLiabilities"),
    ADJUSTMENTREVENUE("AdjustmentRevenue");

    private String value;

    private AccountingCodeType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountingCodeType fromValue(String value) {
        for (AccountingCodeType b : AccountingCodeType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        AccountingCodeType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<AccountingCodeType> {
        public void write(JsonWriter jsonWriter, AccountingCodeType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public AccountingCodeType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return AccountingCodeType.fromValue(value);
        }
    }
}

