/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.CreatePaymentMethodDecryptionRequest;
import com.zuora.model.CreatePaymentMethodDecryptionResponse;
import com.zuora.model.CreatePaymentMethodRequest;
import com.zuora.model.CreatePaymentMethodResponse;
import com.zuora.model.CreatePaymentSessionRequest;
import com.zuora.model.CreatePaymentSessionResponse;
import com.zuora.model.CreateStoredCredentialProfileRequest;
import com.zuora.model.CreateUpdateStoredCredentialProfileResponse;
import com.zuora.model.PaymentMethodResponse;
import com.zuora.model.StoredCredentialProfilesResponse;
import com.zuora.model.UpdatePaymentMethodRequest;
import com.zuora.model.UpdatePaymentMethodResponse;
import com.zuora.model.VerifyPaymentMethodRequest;
import com.zuora.model.VerifyPaymentMethodResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class PaymentMethodsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentMethodsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentMethodsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call cancelStoredCredentialProfileCall(String paymentMethodId, Integer profileNumber, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-methods/{payment-method-id}/profiles/{profile-number}/cancel".replace("{payment-method-id}", this.localVarApiClient.escapeString(paymentMethodId.toString())).replace("{profile-number}", this.localVarApiClient.escapeString(profileNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelStoredCredentialProfileValidateBeforeCall(String paymentMethodId, Integer profileNumber, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling cancelStoredCredentialProfile(Async)");
        }
        if (profileNumber == null) {
            throw new ApiException("Missing the required parameter 'profileNumber' when calling cancelStoredCredentialProfile(Async)");
        }
        return this.cancelStoredCredentialProfileCall(paymentMethodId, profileNumber, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreateUpdateStoredCredentialProfileResponse cancelStoredCredentialProfile(String paymentMethodId, Integer profileNumber, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreateUpdateStoredCredentialProfileResponse> localVarResp = this.cancelStoredCredentialProfileWithHttpInfo(paymentMethodId, profileNumber, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreateUpdateStoredCredentialProfileResponse> cancelStoredCredentialProfileWithHttpInfo(String paymentMethodId, Integer profileNumber, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelStoredCredentialProfileValidateBeforeCall(paymentMethodId, profileNumber, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreateUpdateStoredCredentialProfileResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelStoredCredentialProfileAsync(String paymentMethodId, Integer profileNumber, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreateUpdateStoredCredentialProfileResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelStoredCredentialProfileValidateBeforeCall(paymentMethodId, profileNumber, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreateUpdateStoredCredentialProfileResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelStoredCredentialProfileApi cancelStoredCredentialProfileApi(String paymentMethodId, Integer profileNumber) {
        return new CancelStoredCredentialProfileApi(paymentMethodId, profileNumber);
    }

    private Call createPaymentMethodCall(CreatePaymentMethodRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreatePaymentMethodRequest localVarPostBody = request;
        String localVarPath = "/v1/payment-methods";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPaymentMethodValidateBeforeCall(CreatePaymentMethodRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling createPaymentMethod(Async)");
        }
        return this.createPaymentMethodCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreatePaymentMethodResponse createPaymentMethod(CreatePaymentMethodRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreatePaymentMethodResponse> localVarResp = this.createPaymentMethodWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreatePaymentMethodResponse> createPaymentMethodWithHttpInfo(CreatePaymentMethodRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createPaymentMethodValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreatePaymentMethodResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createPaymentMethodAsync(CreatePaymentMethodRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreatePaymentMethodResponse> _callback) throws ApiException {
        Call localVarCall = this.createPaymentMethodValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreatePaymentMethodResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreatePaymentMethodApi createPaymentMethodApi(CreatePaymentMethodRequest request) {
        return new CreatePaymentMethodApi(request);
    }

    private Call createPaymentSessionCall(CreatePaymentSessionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreatePaymentSessionRequest localVarPostBody = request;
        String localVarPath = "/web-payments/sessions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPaymentSessionValidateBeforeCall(CreatePaymentSessionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling createPaymentSession(Async)");
        }
        return this.createPaymentSessionCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreatePaymentSessionResponse createPaymentSession(CreatePaymentSessionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreatePaymentSessionResponse> localVarResp = this.createPaymentSessionWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreatePaymentSessionResponse> createPaymentSessionWithHttpInfo(CreatePaymentSessionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createPaymentSessionValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreatePaymentSessionResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createPaymentSessionAsync(CreatePaymentSessionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreatePaymentSessionResponse> _callback) throws ApiException {
        Call localVarCall = this.createPaymentSessionValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreatePaymentSessionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreatePaymentSessionApi createPaymentSessionApi(CreatePaymentSessionRequest request) {
        return new CreatePaymentSessionApi(request);
    }

    private Call createStoredCredentialProfileCall(String paymentMethodId, CreateStoredCredentialProfileRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateStoredCredentialProfileRequest localVarPostBody = request;
        String localVarPath = "/v1/payment-methods/{payment-method-id}/profiles".replace("{payment-method-id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createStoredCredentialProfileValidateBeforeCall(String paymentMethodId, CreateStoredCredentialProfileRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling createStoredCredentialProfile(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling createStoredCredentialProfile(Async)");
        }
        return this.createStoredCredentialProfileCall(paymentMethodId, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreateUpdateStoredCredentialProfileResponse createStoredCredentialProfile(String paymentMethodId, CreateStoredCredentialProfileRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreateUpdateStoredCredentialProfileResponse> localVarResp = this.createStoredCredentialProfileWithHttpInfo(paymentMethodId, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreateUpdateStoredCredentialProfileResponse> createStoredCredentialProfileWithHttpInfo(String paymentMethodId, CreateStoredCredentialProfileRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createStoredCredentialProfileValidateBeforeCall(paymentMethodId, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreateUpdateStoredCredentialProfileResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createStoredCredentialProfileAsync(String paymentMethodId, CreateStoredCredentialProfileRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreateUpdateStoredCredentialProfileResponse> _callback) throws ApiException {
        Call localVarCall = this.createStoredCredentialProfileValidateBeforeCall(paymentMethodId, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreateUpdateStoredCredentialProfileResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateStoredCredentialProfileApi createStoredCredentialProfileApi(String paymentMethodId, CreateStoredCredentialProfileRequest request) {
        return new CreateStoredCredentialProfileApi(paymentMethodId, request);
    }

    private Call decryptPaymentMethodCall(CreatePaymentMethodDecryptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreatePaymentMethodDecryptionRequest localVarPostBody = request;
        String localVarPath = "/v1/payment-methods/decryption";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call decryptPaymentMethodValidateBeforeCall(CreatePaymentMethodDecryptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling decryptPaymentMethod(Async)");
        }
        return this.decryptPaymentMethodCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreatePaymentMethodDecryptionResponse decryptPaymentMethod(CreatePaymentMethodDecryptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreatePaymentMethodDecryptionResponse> localVarResp = this.decryptPaymentMethodWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreatePaymentMethodDecryptionResponse> decryptPaymentMethodWithHttpInfo(CreatePaymentMethodDecryptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.decryptPaymentMethodValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreatePaymentMethodDecryptionResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call decryptPaymentMethodAsync(CreatePaymentMethodDecryptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreatePaymentMethodDecryptionResponse> _callback) throws ApiException {
        Call localVarCall = this.decryptPaymentMethodValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreatePaymentMethodDecryptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DecryptPaymentMethodApi decryptPaymentMethodApi(CreatePaymentMethodDecryptionRequest request) {
        return new DecryptPaymentMethodApi(request);
    }

    private Call deletePaymentMethodCall(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-methods/{payment-method-id}".replace("{payment-method-id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deletePaymentMethodValidateBeforeCall(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling deletePaymentMethod(Async)");
        }
        return this.deletePaymentMethodCall(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse deletePaymentMethod(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.deletePaymentMethodWithHttpInfo(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> deletePaymentMethodWithHttpInfo(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deletePaymentMethodValidateBeforeCall(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call deletePaymentMethodAsync(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.deletePaymentMethodValidateBeforeCall(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeletePaymentMethodApi deletePaymentMethodApi(String paymentMethodId) {
        return new DeletePaymentMethodApi(paymentMethodId);
    }

    private Call expireStoredCredentialProfileCall(String paymentMethodId, Integer profileNumber, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-methods/{payment-method-id}/profiles/{profile-number}/expire".replace("{payment-method-id}", this.localVarApiClient.escapeString(paymentMethodId.toString())).replace("{profile-number}", this.localVarApiClient.escapeString(profileNumber.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call expireStoredCredentialProfileValidateBeforeCall(String paymentMethodId, Integer profileNumber, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling expireStoredCredentialProfile(Async)");
        }
        if (profileNumber == null) {
            throw new ApiException("Missing the required parameter 'profileNumber' when calling expireStoredCredentialProfile(Async)");
        }
        return this.expireStoredCredentialProfileCall(paymentMethodId, profileNumber, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreateUpdateStoredCredentialProfileResponse expireStoredCredentialProfile(String paymentMethodId, Integer profileNumber, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreateUpdateStoredCredentialProfileResponse> localVarResp = this.expireStoredCredentialProfileWithHttpInfo(paymentMethodId, profileNumber, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreateUpdateStoredCredentialProfileResponse> expireStoredCredentialProfileWithHttpInfo(String paymentMethodId, Integer profileNumber, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.expireStoredCredentialProfileValidateBeforeCall(paymentMethodId, profileNumber, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreateUpdateStoredCredentialProfileResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call expireStoredCredentialProfileAsync(String paymentMethodId, Integer profileNumber, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreateUpdateStoredCredentialProfileResponse> _callback) throws ApiException {
        Call localVarCall = this.expireStoredCredentialProfileValidateBeforeCall(paymentMethodId, profileNumber, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreateUpdateStoredCredentialProfileResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ExpireStoredCredentialProfileApi expireStoredCredentialProfileApi(String paymentMethodId, Integer profileNumber) {
        return new ExpireStoredCredentialProfileApi(paymentMethodId, profileNumber);
    }

    private Call getPaymentMethodCall(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-methods/{payment-method-id}".replace("{payment-method-id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentMethodValidateBeforeCall(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling getPaymentMethod(Async)");
        }
        return this.getPaymentMethodCall(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected PaymentMethodResponse getPaymentMethod(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<PaymentMethodResponse> localVarResp = this.getPaymentMethodWithHttpInfo(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentMethodResponse> getPaymentMethodWithHttpInfo(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentMethodValidateBeforeCall(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentMethodResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentMethodAsync(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<PaymentMethodResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentMethodValidateBeforeCall(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentMethodResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentMethodApi getPaymentMethodApi(String paymentMethodId) {
        return new GetPaymentMethodApi(paymentMethodId);
    }

    private Call getStoredCredentialProfilesCall(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean includeAll, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-methods/{payment-method-id}/profiles".replace("{payment-method-id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (includeAll != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeAll", includeAll));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStoredCredentialProfilesValidateBeforeCall(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean includeAll, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling getStoredCredentialProfiles(Async)");
        }
        return this.getStoredCredentialProfilesCall(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, includeAll, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected StoredCredentialProfilesResponse getStoredCredentialProfiles(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean includeAll, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<StoredCredentialProfilesResponse> localVarResp = this.getStoredCredentialProfilesWithHttpInfo(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, includeAll, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<StoredCredentialProfilesResponse> getStoredCredentialProfilesWithHttpInfo(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean includeAll, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getStoredCredentialProfilesValidateBeforeCall(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, includeAll, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<StoredCredentialProfilesResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getStoredCredentialProfilesAsync(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean includeAll, String zuoraVersion, String zuoraOrgIds, ApiCallback<StoredCredentialProfilesResponse> _callback) throws ApiException {
        Call localVarCall = this.getStoredCredentialProfilesValidateBeforeCall(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, includeAll, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<StoredCredentialProfilesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetStoredCredentialProfilesApi getStoredCredentialProfilesApi(String paymentMethodId) {
        return new GetStoredCredentialProfilesApi(paymentMethodId);
    }

    private Call scrubPaymentMethodCall(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-methods/{payment-method-id}/scrub".replace("{payment-method-id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call scrubPaymentMethodValidateBeforeCall(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling scrubPaymentMethod(Async)");
        }
        return this.scrubPaymentMethodCall(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse scrubPaymentMethod(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.scrubPaymentMethodWithHttpInfo(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> scrubPaymentMethodWithHttpInfo(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.scrubPaymentMethodValidateBeforeCall(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call scrubPaymentMethodAsync(String paymentMethodId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.scrubPaymentMethodValidateBeforeCall(paymentMethodId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ScrubPaymentMethodApi scrubPaymentMethodApi(String paymentMethodId) {
        return new ScrubPaymentMethodApi(paymentMethodId);
    }

    private Call updatePaymentMethodCall(String paymentMethodId, UpdatePaymentMethodRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdatePaymentMethodRequest localVarPostBody = request;
        String localVarPath = "/v1/payment-methods/{payment-method-id}".replace("{payment-method-id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePaymentMethodValidateBeforeCall(String paymentMethodId, UpdatePaymentMethodRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling updatePaymentMethod(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling updatePaymentMethod(Async)");
        }
        return this.updatePaymentMethodCall(paymentMethodId, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected UpdatePaymentMethodResponse updatePaymentMethod(String paymentMethodId, UpdatePaymentMethodRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<UpdatePaymentMethodResponse> localVarResp = this.updatePaymentMethodWithHttpInfo(paymentMethodId, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<UpdatePaymentMethodResponse> updatePaymentMethodWithHttpInfo(String paymentMethodId, UpdatePaymentMethodRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updatePaymentMethodValidateBeforeCall(paymentMethodId, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<UpdatePaymentMethodResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updatePaymentMethodAsync(String paymentMethodId, UpdatePaymentMethodRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<UpdatePaymentMethodResponse> _callback) throws ApiException {
        Call localVarCall = this.updatePaymentMethodValidateBeforeCall(paymentMethodId, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<UpdatePaymentMethodResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdatePaymentMethodApi updatePaymentMethodApi(String paymentMethodId, UpdatePaymentMethodRequest request) {
        return new UpdatePaymentMethodApi(paymentMethodId, request);
    }

    private Call verifyPaymentMethodCall(String paymentMethodId, VerifyPaymentMethodRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        VerifyPaymentMethodRequest localVarPostBody = body;
        String localVarPath = "/v1/payment-methods/{payment-method-id}/verify".replace("{payment-method-id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call verifyPaymentMethodValidateBeforeCall(String paymentMethodId, VerifyPaymentMethodRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling verifyPaymentMethod(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling verifyPaymentMethod(Async)");
        }
        return this.verifyPaymentMethodCall(paymentMethodId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected VerifyPaymentMethodResponse verifyPaymentMethod(String paymentMethodId, VerifyPaymentMethodRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<VerifyPaymentMethodResponse> localVarResp = this.verifyPaymentMethodWithHttpInfo(paymentMethodId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<VerifyPaymentMethodResponse> verifyPaymentMethodWithHttpInfo(String paymentMethodId, VerifyPaymentMethodRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.verifyPaymentMethodValidateBeforeCall(paymentMethodId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<VerifyPaymentMethodResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call verifyPaymentMethodAsync(String paymentMethodId, VerifyPaymentMethodRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, ApiCallback<VerifyPaymentMethodResponse> _callback) throws ApiException {
        Call localVarCall = this.verifyPaymentMethodValidateBeforeCall(paymentMethodId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<VerifyPaymentMethodResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public VerifyPaymentMethodApi verifyPaymentMethodApi(String paymentMethodId, VerifyPaymentMethodRequest body) {
        return new VerifyPaymentMethodApi(paymentMethodId, body);
    }

    public class VerifyPaymentMethodApi {
        private final String paymentMethodId;
        private final VerifyPaymentMethodRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private VerifyPaymentMethodApi(String paymentMethodId, VerifyPaymentMethodRequest body) {
            this.paymentMethodId = paymentMethodId;
            this.body = body;
        }

        public VerifyPaymentMethodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public VerifyPaymentMethodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public VerifyPaymentMethodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public VerifyPaymentMethodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public VerifyPaymentMethodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public VerifyPaymentMethodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodsApi.this.verifyPaymentMethodCall(this.paymentMethodId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public VerifyPaymentMethodResponse execute() throws ApiException {
            ApiResponse<VerifyPaymentMethodResponse> localVarResp = PaymentMethodsApi.this.verifyPaymentMethodWithHttpInfo(this.paymentMethodId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<VerifyPaymentMethodResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodsApi.this.verifyPaymentMethodWithHttpInfo(this.paymentMethodId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<VerifyPaymentMethodResponse> _callback) throws ApiException {
            return PaymentMethodsApi.this.verifyPaymentMethodAsync(this.paymentMethodId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class UpdatePaymentMethodApi {
        private final String paymentMethodId;
        private final UpdatePaymentMethodRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdatePaymentMethodApi(String paymentMethodId, UpdatePaymentMethodRequest request) {
            this.paymentMethodId = paymentMethodId;
            this.request = request;
        }

        public UpdatePaymentMethodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdatePaymentMethodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdatePaymentMethodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdatePaymentMethodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdatePaymentMethodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdatePaymentMethodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdatePaymentMethodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodsApi.this.updatePaymentMethodCall(this.paymentMethodId, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public UpdatePaymentMethodResponse execute() throws ApiException {
            ApiResponse<UpdatePaymentMethodResponse> localVarResp = PaymentMethodsApi.this.updatePaymentMethodWithHttpInfo(this.paymentMethodId, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<UpdatePaymentMethodResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodsApi.this.updatePaymentMethodWithHttpInfo(this.paymentMethodId, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<UpdatePaymentMethodResponse> _callback) throws ApiException {
            return PaymentMethodsApi.this.updatePaymentMethodAsync(this.paymentMethodId, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class ScrubPaymentMethodApi {
        private final String paymentMethodId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ScrubPaymentMethodApi(String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
        }

        public ScrubPaymentMethodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ScrubPaymentMethodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ScrubPaymentMethodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ScrubPaymentMethodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ScrubPaymentMethodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ScrubPaymentMethodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ScrubPaymentMethodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodsApi.this.scrubPaymentMethodCall(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse<CommonResponse> localVarResp = PaymentMethodsApi.this.scrubPaymentMethodWithHttpInfo(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodsApi.this.scrubPaymentMethodWithHttpInfo(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return PaymentMethodsApi.this.scrubPaymentMethodAsync(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetStoredCredentialProfilesApi {
        private final String paymentMethodId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Boolean includeAll;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetStoredCredentialProfilesApi(String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
        }

        public GetStoredCredentialProfilesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetStoredCredentialProfilesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetStoredCredentialProfilesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetStoredCredentialProfilesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetStoredCredentialProfilesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetStoredCredentialProfilesApi includeAll(Boolean includeAll) {
            this.includeAll = includeAll;
            return this;
        }

        public GetStoredCredentialProfilesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetStoredCredentialProfilesApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodsApi.this.getStoredCredentialProfilesCall(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.includeAll, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public StoredCredentialProfilesResponse execute() throws ApiException {
            ApiResponse<StoredCredentialProfilesResponse> localVarResp = PaymentMethodsApi.this.getStoredCredentialProfilesWithHttpInfo(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.includeAll, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<StoredCredentialProfilesResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodsApi.this.getStoredCredentialProfilesWithHttpInfo(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.includeAll, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<StoredCredentialProfilesResponse> _callback) throws ApiException {
            return PaymentMethodsApi.this.getStoredCredentialProfilesAsync(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.includeAll, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetPaymentMethodApi {
        private final String paymentMethodId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetPaymentMethodApi(String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
        }

        public GetPaymentMethodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentMethodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentMethodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentMethodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentMethodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentMethodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentMethodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodsApi.this.getPaymentMethodCall(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public PaymentMethodResponse execute() throws ApiException {
            ApiResponse<PaymentMethodResponse> localVarResp = PaymentMethodsApi.this.getPaymentMethodWithHttpInfo(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<PaymentMethodResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodsApi.this.getPaymentMethodWithHttpInfo(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<PaymentMethodResponse> _callback) throws ApiException {
            return PaymentMethodsApi.this.getPaymentMethodAsync(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class ExpireStoredCredentialProfileApi {
        private final String paymentMethodId;
        private final Integer profileNumber;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ExpireStoredCredentialProfileApi(String paymentMethodId, Integer profileNumber) {
            this.paymentMethodId = paymentMethodId;
            this.profileNumber = profileNumber;
        }

        public ExpireStoredCredentialProfileApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public ExpireStoredCredentialProfileApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ExpireStoredCredentialProfileApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ExpireStoredCredentialProfileApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ExpireStoredCredentialProfileApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ExpireStoredCredentialProfileApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ExpireStoredCredentialProfileApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ExpireStoredCredentialProfileApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodsApi.this.expireStoredCredentialProfileCall(this.paymentMethodId, this.profileNumber, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreateUpdateStoredCredentialProfileResponse execute() throws ApiException {
            ApiResponse<CreateUpdateStoredCredentialProfileResponse> localVarResp = PaymentMethodsApi.this.expireStoredCredentialProfileWithHttpInfo(this.paymentMethodId, this.profileNumber, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreateUpdateStoredCredentialProfileResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodsApi.this.expireStoredCredentialProfileWithHttpInfo(this.paymentMethodId, this.profileNumber, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreateUpdateStoredCredentialProfileResponse> _callback) throws ApiException {
            return PaymentMethodsApi.this.expireStoredCredentialProfileAsync(this.paymentMethodId, this.profileNumber, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class DeletePaymentMethodApi {
        private final String paymentMethodId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private DeletePaymentMethodApi(String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
        }

        public DeletePaymentMethodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeletePaymentMethodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeletePaymentMethodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeletePaymentMethodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeletePaymentMethodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeletePaymentMethodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeletePaymentMethodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodsApi.this.deletePaymentMethodCall(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse<CommonResponse> localVarResp = PaymentMethodsApi.this.deletePaymentMethodWithHttpInfo(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodsApi.this.deletePaymentMethodWithHttpInfo(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return PaymentMethodsApi.this.deletePaymentMethodAsync(this.paymentMethodId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class DecryptPaymentMethodApi {
        private final CreatePaymentMethodDecryptionRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private DecryptPaymentMethodApi(CreatePaymentMethodDecryptionRequest request) {
            this.request = request;
        }

        public DecryptPaymentMethodApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public DecryptPaymentMethodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DecryptPaymentMethodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DecryptPaymentMethodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DecryptPaymentMethodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DecryptPaymentMethodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DecryptPaymentMethodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DecryptPaymentMethodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodsApi.this.decryptPaymentMethodCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreatePaymentMethodDecryptionResponse execute() throws ApiException {
            ApiResponse<CreatePaymentMethodDecryptionResponse> localVarResp = PaymentMethodsApi.this.decryptPaymentMethodWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreatePaymentMethodDecryptionResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodsApi.this.decryptPaymentMethodWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreatePaymentMethodDecryptionResponse> _callback) throws ApiException {
            return PaymentMethodsApi.this.decryptPaymentMethodAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateStoredCredentialProfileApi {
        private final String paymentMethodId;
        private final CreateStoredCredentialProfileRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateStoredCredentialProfileApi(String paymentMethodId, CreateStoredCredentialProfileRequest request) {
            this.paymentMethodId = paymentMethodId;
            this.request = request;
        }

        public CreateStoredCredentialProfileApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateStoredCredentialProfileApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateStoredCredentialProfileApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateStoredCredentialProfileApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateStoredCredentialProfileApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateStoredCredentialProfileApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateStoredCredentialProfileApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateStoredCredentialProfileApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodsApi.this.createStoredCredentialProfileCall(this.paymentMethodId, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreateUpdateStoredCredentialProfileResponse execute() throws ApiException {
            ApiResponse<CreateUpdateStoredCredentialProfileResponse> localVarResp = PaymentMethodsApi.this.createStoredCredentialProfileWithHttpInfo(this.paymentMethodId, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreateUpdateStoredCredentialProfileResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodsApi.this.createStoredCredentialProfileWithHttpInfo(this.paymentMethodId, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreateUpdateStoredCredentialProfileResponse> _callback) throws ApiException {
            return PaymentMethodsApi.this.createStoredCredentialProfileAsync(this.paymentMethodId, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreatePaymentSessionApi {
        private final CreatePaymentSessionRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreatePaymentSessionApi(CreatePaymentSessionRequest request) {
            this.request = request;
        }

        public CreatePaymentSessionApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreatePaymentSessionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreatePaymentSessionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreatePaymentSessionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreatePaymentSessionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreatePaymentSessionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreatePaymentSessionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreatePaymentSessionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodsApi.this.createPaymentSessionCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreatePaymentSessionResponse execute() throws ApiException {
            ApiResponse<CreatePaymentSessionResponse> localVarResp = PaymentMethodsApi.this.createPaymentSessionWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreatePaymentSessionResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodsApi.this.createPaymentSessionWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreatePaymentSessionResponse> _callback) throws ApiException {
            return PaymentMethodsApi.this.createPaymentSessionAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreatePaymentMethodApi {
        private final CreatePaymentMethodRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreatePaymentMethodApi(CreatePaymentMethodRequest request) {
            this.request = request;
        }

        public CreatePaymentMethodApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreatePaymentMethodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreatePaymentMethodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreatePaymentMethodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreatePaymentMethodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreatePaymentMethodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreatePaymentMethodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreatePaymentMethodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodsApi.this.createPaymentMethodCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreatePaymentMethodResponse execute() throws ApiException {
            ApiResponse<CreatePaymentMethodResponse> localVarResp = PaymentMethodsApi.this.createPaymentMethodWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreatePaymentMethodResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodsApi.this.createPaymentMethodWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreatePaymentMethodResponse> _callback) throws ApiException {
            return PaymentMethodsApi.this.createPaymentMethodAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CancelStoredCredentialProfileApi {
        private final String paymentMethodId;
        private final Integer profileNumber;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CancelStoredCredentialProfileApi(String paymentMethodId, Integer profileNumber) {
            this.paymentMethodId = paymentMethodId;
            this.profileNumber = profileNumber;
        }

        public CancelStoredCredentialProfileApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CancelStoredCredentialProfileApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CancelStoredCredentialProfileApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CancelStoredCredentialProfileApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CancelStoredCredentialProfileApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CancelStoredCredentialProfileApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CancelStoredCredentialProfileApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CancelStoredCredentialProfileApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentMethodsApi.this.cancelStoredCredentialProfileCall(this.paymentMethodId, this.profileNumber, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreateUpdateStoredCredentialProfileResponse execute() throws ApiException {
            ApiResponse<CreateUpdateStoredCredentialProfileResponse> localVarResp = PaymentMethodsApi.this.cancelStoredCredentialProfileWithHttpInfo(this.paymentMethodId, this.profileNumber, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreateUpdateStoredCredentialProfileResponse> executeWithHttpInfo() throws ApiException {
            return PaymentMethodsApi.this.cancelStoredCredentialProfileWithHttpInfo(this.paymentMethodId, this.profileNumber, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreateUpdateStoredCredentialProfileResponse> _callback) throws ApiException {
            return PaymentMethodsApi.this.cancelStoredCredentialProfileAsync(this.paymentMethodId, this.profileNumber, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

