/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum BillingDocumentType {
    INVOICE("Invoice"),
    CREDITMEMO("CreditMemo"),
    DEBITMEMO("DebitMemo");

    private String value;

    private BillingDocumentType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BillingDocumentType fromValue(String value) {
        for (BillingDocumentType b : BillingDocumentType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        BillingDocumentType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<BillingDocumentType> {
        public void write(JsonWriter jsonWriter, BillingDocumentType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public BillingDocumentType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return BillingDocumentType.fromValue(value);
        }
    }
}

