/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.CreateOmniChannelSubscriptionRequest;
import com.zuora.model.CreateOmniChannelSubscriptionResponse;
import com.zuora.model.GetOmniChannelSubscriptionResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class OmniChannelSubscriptionsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OmniChannelSubscriptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OmniChannelSubscriptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createOmniChannelSubscriptionCall(CreateOmniChannelSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateOmniChannelSubscriptionRequest localVarPostBody = request;
        String localVarPath = "/v1/omni-channel-subscriptions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOmniChannelSubscriptionValidateBeforeCall(CreateOmniChannelSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling createOmniChannelSubscription(Async)");
        }
        return this.createOmniChannelSubscriptionCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreateOmniChannelSubscriptionResponse createOmniChannelSubscription(CreateOmniChannelSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreateOmniChannelSubscriptionResponse> localVarResp = this.createOmniChannelSubscriptionWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreateOmniChannelSubscriptionResponse> createOmniChannelSubscriptionWithHttpInfo(CreateOmniChannelSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createOmniChannelSubscriptionValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreateOmniChannelSubscriptionResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createOmniChannelSubscriptionAsync(CreateOmniChannelSubscriptionRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreateOmniChannelSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.createOmniChannelSubscriptionValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreateOmniChannelSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateOmniChannelSubscriptionApi createOmniChannelSubscriptionApi(CreateOmniChannelSubscriptionRequest request) {
        return new CreateOmniChannelSubscriptionApi(request);
    }

    private Call deleteOmniChannelSubscriptionCall(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/omni-channel-subscriptions/{subscriptionKey}".replace("{subscriptionKey}", this.localVarApiClient.escapeString(subscriptionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteOmniChannelSubscriptionValidateBeforeCall(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionKey == null) {
            throw new ApiException("Missing the required parameter 'subscriptionKey' when calling deleteOmniChannelSubscription(Async)");
        }
        return this.deleteOmniChannelSubscriptionCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse deleteOmniChannelSubscription(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.deleteOmniChannelSubscriptionWithHttpInfo(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> deleteOmniChannelSubscriptionWithHttpInfo(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteOmniChannelSubscriptionValidateBeforeCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call deleteOmniChannelSubscriptionAsync(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteOmniChannelSubscriptionValidateBeforeCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteOmniChannelSubscriptionApi deleteOmniChannelSubscriptionApi(String subscriptionKey) {
        return new DeleteOmniChannelSubscriptionApi(subscriptionKey);
    }

    private Call getOmniChannelSubscriptionCall(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getAccountDetails, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/omni-channel-subscriptions/{subscriptionKey}".replace("{subscriptionKey}", this.localVarApiClient.escapeString(subscriptionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (getAccountDetails != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("getAccountDetails", getAccountDetails));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOmniChannelSubscriptionValidateBeforeCall(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getAccountDetails, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (subscriptionKey == null) {
            throw new ApiException("Missing the required parameter 'subscriptionKey' when calling getOmniChannelSubscription(Async)");
        }
        return this.getOmniChannelSubscriptionCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, getAccountDetails, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetOmniChannelSubscriptionResponse getOmniChannelSubscription(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getAccountDetails, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetOmniChannelSubscriptionResponse> localVarResp = this.getOmniChannelSubscriptionWithHttpInfo(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, getAccountDetails, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetOmniChannelSubscriptionResponse> getOmniChannelSubscriptionWithHttpInfo(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getAccountDetails, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getOmniChannelSubscriptionValidateBeforeCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, getAccountDetails, zuoraVersion, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GetOmniChannelSubscriptionResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getOmniChannelSubscriptionAsync(String subscriptionKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Boolean getAccountDetails, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetOmniChannelSubscriptionResponse> _callback) throws ApiException {
        Call localVarCall = this.getOmniChannelSubscriptionValidateBeforeCall(subscriptionKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, getAccountDetails, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetOmniChannelSubscriptionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetOmniChannelSubscriptionApi getOmniChannelSubscriptionApi(String subscriptionKey) {
        return new GetOmniChannelSubscriptionApi(subscriptionKey);
    }

    public class GetOmniChannelSubscriptionApi {
        private final String subscriptionKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Boolean getAccountDetails;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetOmniChannelSubscriptionApi(String subscriptionKey) {
            this.subscriptionKey = subscriptionKey;
        }

        public GetOmniChannelSubscriptionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetOmniChannelSubscriptionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetOmniChannelSubscriptionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetOmniChannelSubscriptionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetOmniChannelSubscriptionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetOmniChannelSubscriptionApi getAccountDetails(Boolean getAccountDetails) {
            this.getAccountDetails = getAccountDetails;
            return this;
        }

        public GetOmniChannelSubscriptionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetOmniChannelSubscriptionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OmniChannelSubscriptionsApi.this.getOmniChannelSubscriptionCall(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.getAccountDetails, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetOmniChannelSubscriptionResponse execute() throws ApiException {
            ApiResponse<GetOmniChannelSubscriptionResponse> localVarResp = OmniChannelSubscriptionsApi.this.getOmniChannelSubscriptionWithHttpInfo(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.getAccountDetails, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<GetOmniChannelSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return OmniChannelSubscriptionsApi.this.getOmniChannelSubscriptionWithHttpInfo(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.getAccountDetails, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetOmniChannelSubscriptionResponse> _callback) throws ApiException {
            return OmniChannelSubscriptionsApi.this.getOmniChannelSubscriptionAsync(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.getAccountDetails, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class DeleteOmniChannelSubscriptionApi {
        private final String subscriptionKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private DeleteOmniChannelSubscriptionApi(String subscriptionKey) {
            this.subscriptionKey = subscriptionKey;
        }

        public DeleteOmniChannelSubscriptionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteOmniChannelSubscriptionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteOmniChannelSubscriptionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteOmniChannelSubscriptionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteOmniChannelSubscriptionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteOmniChannelSubscriptionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeleteOmniChannelSubscriptionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OmniChannelSubscriptionsApi.this.deleteOmniChannelSubscriptionCall(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse<CommonResponse> localVarResp = OmniChannelSubscriptionsApi.this.deleteOmniChannelSubscriptionWithHttpInfo(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return OmniChannelSubscriptionsApi.this.deleteOmniChannelSubscriptionWithHttpInfo(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return OmniChannelSubscriptionsApi.this.deleteOmniChannelSubscriptionAsync(this.subscriptionKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateOmniChannelSubscriptionApi {
        private final CreateOmniChannelSubscriptionRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateOmniChannelSubscriptionApi(CreateOmniChannelSubscriptionRequest request) {
            this.request = request;
        }

        public CreateOmniChannelSubscriptionApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateOmniChannelSubscriptionApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateOmniChannelSubscriptionApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateOmniChannelSubscriptionApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateOmniChannelSubscriptionApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateOmniChannelSubscriptionApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateOmniChannelSubscriptionApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateOmniChannelSubscriptionApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return OmniChannelSubscriptionsApi.this.createOmniChannelSubscriptionCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreateOmniChannelSubscriptionResponse execute() throws ApiException {
            ApiResponse<CreateOmniChannelSubscriptionResponse> localVarResp = OmniChannelSubscriptionsApi.this.createOmniChannelSubscriptionWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return localVarResp.getData();
        }

        public ApiResponse<CreateOmniChannelSubscriptionResponse> executeWithHttpInfo() throws ApiException {
            return OmniChannelSubscriptionsApi.this.createOmniChannelSubscriptionWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreateOmniChannelSubscriptionResponse> _callback) throws ApiException {
            return OmniChannelSubscriptionsApi.this.createOmniChannelSubscriptionAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

