/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.TaxationItemCreateRequest;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class BillingDocumentItemCreateRequest {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DEFERRED_REVENUE_ACCOUNT = "deferred_revenue_account";
    @SerializedName(value="deferred_revenue_account")
    private String deferredRevenueAccount;
    public static final String SERIALIZED_NAME_ON_ACCOUNT_ACCOUNT = "on_account_account";
    @SerializedName(value="on_account_account")
    private String onAccountAccount;
    public static final String SERIALIZED_NAME_RECOGNIZED_REVENUE_ACCOUNT = "recognized_revenue_account";
    @SerializedName(value="recognized_revenue_account")
    private String recognizedRevenueAccount;
    public static final String SERIALIZED_NAME_REVENUE_RECOGNITION_RULE_NAME = "revenue_recognition_rule_name";
    @SerializedName(value="revenue_recognition_rule_name")
    private String revenueRecognitionRuleName;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_SERVICE_END = "service_end";
    @SerializedName(value="service_end")
    private LocalDate serviceEnd;
    public static final String SERIALIZED_NAME_SERVICE_START = "service_start";
    @SerializedName(value="service_start")
    private LocalDate serviceStart;
    public static final String SERIALIZED_NAME_SKU = "sku";
    @SerializedName(value="sku")
    private String sku;
    public static final String SERIALIZED_NAME_TAX_INCLUSIVE = "tax_inclusive";
    @SerializedName(value="tax_inclusive")
    private Boolean taxInclusive;
    public static final String SERIALIZED_NAME_UNIT_OF_MEASURE = "unit_of_measure";
    @SerializedName(value="unit_of_measure")
    private String unitOfMeasure;
    public static final String SERIALIZED_NAME_TAXATION_ITEMS = "taxation_items";
    @SerializedName(value="taxation_items")
    private List<TaxationItemCreateRequest> taxationItems = null;
    public static final String SERIALIZED_NAME_UNIT_AMOUNT = "unit_amount";
    @SerializedName(value="unit_amount")
    private BigDecimal unitAmount;
    public static final String SERIALIZED_NAME_BOOKING_REFERENCE = "booking_reference";
    @SerializedName(value="booking_reference")
    private String bookingReference;
    public static final String SERIALIZED_NAME_PRICE_ID = "price_id";
    @SerializedName(value="price_id")
    private String priceId;
    public static final String SERIALIZED_NAME_PURCHASE_ORDER_NUMBER = "purchase_order_number";
    @SerializedName(value="purchase_order_number")
    private String purchaseOrderNumber;
    public static final String SERIALIZED_NAME_TAX_CODE = "tax_code";
    @SerializedName(value="tax_code")
    private String taxCode;
    public static final String SERIALIZED_NAME_DOCUMENT_ITEM_DATE = "document_item_date";
    @SerializedName(value="document_item_date")
    private OffsetDateTime documentItemDate;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_INVOICE_ITEM_ID = "invoice_item_id";
    @SerializedName(value="invoice_item_id")
    private String invoiceItemId;
    public static final String SERIALIZED_NAME_ACCOUNTING_CODE = "accounting_code";
    @SerializedName(value="accounting_code")
    private String accountingCode;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;

    public BillingDocumentItemCreateRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount (in the currency specified) of the invoice item. This should always be equal to unit_amount * quantity.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BillingDocumentItemCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string associated with the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BillingDocumentItemCreateRequest deferredRevenueAccount(String deferredRevenueAccount) {
        this.deferredRevenueAccount = deferredRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getDeferredRevenueAccount() {
        return this.deferredRevenueAccount;
    }

    public void setDeferredRevenueAccount(String deferredRevenueAccount) {
        this.deferredRevenueAccount = deferredRevenueAccount;
    }

    public BillingDocumentItemCreateRequest onAccountAccount(String onAccountAccount) {
        this.onAccountAccount = onAccountAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getOnAccountAccount() {
        return this.onAccountAccount;
    }

    public void setOnAccountAccount(String onAccountAccount) {
        this.onAccountAccount = onAccountAccount;
    }

    public BillingDocumentItemCreateRequest recognizedRevenueAccount(String recognizedRevenueAccount) {
        this.recognizedRevenueAccount = recognizedRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getRecognizedRevenueAccount() {
        return this.recognizedRevenueAccount;
    }

    public void setRecognizedRevenueAccount(String recognizedRevenueAccount) {
        this.recognizedRevenueAccount = recognizedRevenueAccount;
    }

    public BillingDocumentItemCreateRequest revenueRecognitionRuleName(String revenueRecognitionRuleName) {
        this.revenueRecognitionRuleName = revenueRecognitionRuleName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the revenue recognition rule governing the revenue schedule.")
    public String getRevenueRecognitionRuleName() {
        return this.revenueRecognitionRuleName;
    }

    public void setRevenueRecognitionRuleName(String revenueRecognitionRuleName) {
        this.revenueRecognitionRuleName = revenueRecognitionRuleName;
    }

    public BillingDocumentItemCreateRequest quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of units of this item.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BillingDocumentItemCreateRequest serviceEnd(LocalDate serviceEnd) {
        this.serviceEnd = serviceEnd;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The end date of the service period associated with this billing document item. If the price for the associated subscription item is a one-time fee, then this date is the date of that subscription item.")
    public LocalDate getServiceEnd() {
        return this.serviceEnd;
    }

    public void setServiceEnd(LocalDate serviceEnd) {
        this.serviceEnd = serviceEnd;
    }

    public BillingDocumentItemCreateRequest serviceStart(LocalDate serviceStart) {
        this.serviceStart = serviceStart;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", required=true, value="The start date of the service period associated with this billing document item. If the price for the associated subscription item is a one-time fee, then this date is the date of that subscription item.")
    public LocalDate getServiceStart() {
        return this.serviceStart;
    }

    public void setServiceStart(LocalDate serviceStart) {
        this.serviceStart = serviceStart;
    }

    public BillingDocumentItemCreateRequest sku(String sku) {
        this.sku = sku;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique SKU (stock keeping unit) of the product associated with this item.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public BillingDocumentItemCreateRequest taxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the billing document item amount is inclusive or exclusive of tax.")
    public Boolean getTaxInclusive() {
        return this.taxInclusive;
    }

    public void setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
    }

    public BillingDocumentItemCreateRequest unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the units used to measure usage.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public BillingDocumentItemCreateRequest taxationItems(List<TaxationItemCreateRequest> taxationItems) {
        this.taxationItems = taxationItems;
        return this;
    }

    public BillingDocumentItemCreateRequest addTaxationItemsItem(TaxationItemCreateRequest taxationItemsItem) {
        if (this.taxationItems == null) {
            this.taxationItems = new ArrayList<TaxationItemCreateRequest>();
        }
        this.taxationItems.add(taxationItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of taxation items.")
    public List<TaxationItemCreateRequest> getTaxationItems() {
        return this.taxationItems;
    }

    public void setTaxationItems(List<TaxationItemCreateRequest> taxationItems) {
        this.taxationItems = taxationItems;
    }

    public BillingDocumentItemCreateRequest unitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unit amount (in the currency specified) of the billing document item.")
    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
    }

    public BillingDocumentItemCreateRequest bookingReference(String bookingReference) {
        this.bookingReference = bookingReference;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The booking reference for this billing document item.")
    public String getBookingReference() {
        return this.bookingReference;
    }

    public void setBookingReference(String bookingReference) {
        this.bookingReference = bookingReference;
    }

    public BillingDocumentItemCreateRequest priceId(String priceId) {
        this.priceId = priceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the price this billing document item is associated with.")
    public String getPriceId() {
        return this.priceId;
    }

    public void setPriceId(String priceId) {
        this.priceId = priceId;
    }

    public BillingDocumentItemCreateRequest purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The purchase order number associated with this billing document item.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public BillingDocumentItemCreateRequest taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The designated tax code.")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public BillingDocumentItemCreateRequest documentItemDate(OffsetDateTime documentItemDate) {
        this.documentItemDate = documentItemDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2022-01-01T07:08:12-07:00", value="The date when the billing document item takes effect. This field is applicable only if the `type` field is set to `invoice`.")
    public OffsetDateTime getDocumentItemDate() {
        return this.documentItemDate;
    }

    public void setDocumentItemDate(OffsetDateTime documentItemDate) {
        this.documentItemDate = documentItemDate;
    }

    public BillingDocumentItemCreateRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the billing document item displayed to customers on the billing document.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BillingDocumentItemCreateRequest invoiceItemId(String invoiceItemId) {
        this.invoiceItemId = invoiceItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the invoice item associated with this billing document item.")
    public String getInvoiceItemId() {
        return this.invoiceItemId;
    }

    public void setInvoiceItemId(String invoiceItemId) {
        this.invoiceItemId = invoiceItemId;
    }

    public BillingDocumentItemCreateRequest accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public BillingDocumentItemCreateRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public BillingDocumentItemCreateRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingDocumentItemCreateRequest billingDocumentItemCreateRequest = (BillingDocumentItemCreateRequest)o;
        return Objects.equals(this.amount, billingDocumentItemCreateRequest.amount) && Objects.equals(this.description, billingDocumentItemCreateRequest.description) && Objects.equals(this.deferredRevenueAccount, billingDocumentItemCreateRequest.deferredRevenueAccount) && Objects.equals(this.onAccountAccount, billingDocumentItemCreateRequest.onAccountAccount) && Objects.equals(this.recognizedRevenueAccount, billingDocumentItemCreateRequest.recognizedRevenueAccount) && Objects.equals(this.revenueRecognitionRuleName, billingDocumentItemCreateRequest.revenueRecognitionRuleName) && Objects.equals(this.quantity, billingDocumentItemCreateRequest.quantity) && Objects.equals(this.serviceEnd, billingDocumentItemCreateRequest.serviceEnd) && Objects.equals(this.serviceStart, billingDocumentItemCreateRequest.serviceStart) && Objects.equals(this.sku, billingDocumentItemCreateRequest.sku) && Objects.equals(this.taxInclusive, billingDocumentItemCreateRequest.taxInclusive) && Objects.equals(this.unitOfMeasure, billingDocumentItemCreateRequest.unitOfMeasure) && Objects.equals(this.taxationItems, billingDocumentItemCreateRequest.taxationItems) && Objects.equals(this.unitAmount, billingDocumentItemCreateRequest.unitAmount) && Objects.equals(this.bookingReference, billingDocumentItemCreateRequest.bookingReference) && Objects.equals(this.priceId, billingDocumentItemCreateRequest.priceId) && Objects.equals(this.purchaseOrderNumber, billingDocumentItemCreateRequest.purchaseOrderNumber) && Objects.equals(this.taxCode, billingDocumentItemCreateRequest.taxCode) && Objects.equals(this.documentItemDate, billingDocumentItemCreateRequest.documentItemDate) && Objects.equals(this.name, billingDocumentItemCreateRequest.name) && Objects.equals(this.invoiceItemId, billingDocumentItemCreateRequest.invoiceItemId) && Objects.equals(this.accountingCode, billingDocumentItemCreateRequest.accountingCode) && Objects.equals(this.customFields, billingDocumentItemCreateRequest.customFields);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.description, this.deferredRevenueAccount, this.onAccountAccount, this.recognizedRevenueAccount, this.revenueRecognitionRuleName, this.quantity, this.serviceEnd, this.serviceStart, this.sku, this.taxInclusive, this.unitOfMeasure, this.taxationItems, this.unitAmount, this.bookingReference, this.priceId, this.purchaseOrderNumber, this.taxCode, this.documentItemDate, this.name, this.invoiceItemId, this.accountingCode, this.customFields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingDocumentItemCreateRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    deferredRevenueAccount: ").append(this.toIndentedString(this.deferredRevenueAccount)).append("\n");
        sb.append("    onAccountAccount: ").append(this.toIndentedString(this.onAccountAccount)).append("\n");
        sb.append("    recognizedRevenueAccount: ").append(this.toIndentedString(this.recognizedRevenueAccount)).append("\n");
        sb.append("    revenueRecognitionRuleName: ").append(this.toIndentedString(this.revenueRecognitionRuleName)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    serviceEnd: ").append(this.toIndentedString(this.serviceEnd)).append("\n");
        sb.append("    serviceStart: ").append(this.toIndentedString(this.serviceStart)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    taxInclusive: ").append(this.toIndentedString(this.taxInclusive)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    taxationItems: ").append(this.toIndentedString(this.taxationItems)).append("\n");
        sb.append("    unitAmount: ").append(this.toIndentedString(this.unitAmount)).append("\n");
        sb.append("    bookingReference: ").append(this.toIndentedString(this.bookingReference)).append("\n");
        sb.append("    priceId: ").append(this.toIndentedString(this.priceId)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    documentItemDate: ").append(this.toIndentedString(this.documentItemDate)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    invoiceItemId: ").append(this.toIndentedString(this.invoiceItemId)).append("\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

