/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.AddressFieldDefinitions;

@ApiModel(description="Billing information associated with the payment method that may be used or required by specific payment method types.")
public class BillingDetails {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private AddressFieldDefinitions address;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_PHONE = "phone";
    @SerializedName(value="phone")
    private String phone;

    public BillingDetails name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Amy Lawrence", value="Customer full name or business name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BillingDetails address(AddressFieldDefinitions address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AddressFieldDefinitions getAddress() {
        return this.address;
    }

    public void setAddress(AddressFieldDefinitions address) {
        this.address = address;
    }

    public BillingDetails email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="alawrence@gmail.com", value="Customer email address.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public BillingDetails phone(String phone) {
        this.phone = phone;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="(888)976-9056", value="Customer phone (including extension).")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingDetails billingDetails = (BillingDetails)o;
        return Objects.equals(this.name, billingDetails.name) && Objects.equals(this.address, billingDetails.address) && Objects.equals(this.email, billingDetails.email) && Objects.equals(this.phone, billingDetails.phone);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.address, this.email, this.phone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingDetails {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

