/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.QueryRunFile;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Query run information.")
public class QueryRun {
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_SQL = "sql";
    @SerializedName(value="sql")
    private String sql;
    public static final String SERIALIZED_NAME_REMAINING_ATTEMPTS = "remaining_attempts";
    @SerializedName(value="remaining_attempts")
    private BigDecimal remainingAttempts;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_FILE = "file";
    @SerializedName(value="file")
    private QueryRunFile _file;
    public static final String SERIALIZED_NAME_NUMBER_OF_ROWS = "number_of_rows";
    @SerializedName(value="number_of_rows")
    private BigDecimal numberOfRows;
    public static final String SERIALIZED_NAME_PROCESSING_DURATION = "processing_duration";
    @SerializedName(value="processing_duration")
    private BigDecimal processingDuration;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_COLUMN_SEPARATOR = "column_separator";
    @SerializedName(value="column_separator")
    private String columnSeparator;

    public QueryRun() {
    }

    public QueryRun(String createdById, String id, OffsetDateTime updatedTime) {
        this();
        this.createdById = createdById;
        this.id = id;
        this.updatedTime = updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object.")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    public QueryRun sql(String sql) {
        this.sql = sql;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The SQL statement of the query.")
    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public QueryRun remainingAttempts(BigDecimal remainingAttempts) {
        this.remainingAttempts = remainingAttempts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The remaining number of times Zuora will attempt the query before terminating the query and setting the state to `failed`.")
    public BigDecimal getRemainingAttempts() {
        return this.remainingAttempts;
    }

    public void setRemainingAttempts(BigDecimal remainingAttempts) {
        this.remainingAttempts = remainingAttempts;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO-8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    public QueryRun _file(QueryRunFile _file) {
        this._file = _file;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public QueryRunFile getFile() {
        return this._file;
    }

    public void setFile(QueryRunFile _file) {
        this._file = _file;
    }

    public QueryRun numberOfRows(BigDecimal numberOfRows) {
        this.numberOfRows = numberOfRows;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of rows in the output file.")
    public BigDecimal getNumberOfRows() {
        return this.numberOfRows;
    }

    public void setNumberOfRows(BigDecimal numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    public QueryRun processingDuration(BigDecimal processingDuration) {
        this.processingDuration = processingDuration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time taken to process the query in milliseconds.")
    public BigDecimal getProcessingDuration() {
        return this.processingDuration;
    }

    public void setProcessingDuration(BigDecimal processingDuration) {
        this.processingDuration = processingDuration;
    }

    public QueryRun state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The query's execution state, which will be completed for successful runs.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public QueryRun columnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The character used as delimiter to separate values in the output file.")
    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRun queryRun = (QueryRun)o;
        return Objects.equals(this.createdById, queryRun.createdById) && Objects.equals(this.id, queryRun.id) && Objects.equals(this.sql, queryRun.sql) && Objects.equals(this.remainingAttempts, queryRun.remainingAttempts) && Objects.equals(this.updatedTime, queryRun.updatedTime) && Objects.equals(this._file, queryRun._file) && Objects.equals(this.numberOfRows, queryRun.numberOfRows) && Objects.equals(this.processingDuration, queryRun.processingDuration) && Objects.equals((Object)this.state, (Object)queryRun.state) && Objects.equals(this.columnSeparator, queryRun.columnSeparator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdById, this.id, this.sql, this.remainingAttempts, this.updatedTime, this._file, this.numberOfRows, this.processingDuration, this.state, this.columnSeparator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryRun {\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    sql: ").append(this.toIndentedString(this.sql)).append("\n");
        sb.append("    remainingAttempts: ").append(this.toIndentedString(this.remainingAttempts)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    _file: ").append(this.toIndentedString(this._file)).append("\n");
        sb.append("    numberOfRows: ").append(this.toIndentedString(this.numberOfRows)).append("\n");
        sb.append("    processingDuration: ").append(this.toIndentedString(this.processingDuration)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    columnSeparator: ").append(this.toIndentedString(this.columnSeparator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        PENDING("pending"),
        ACCEPTED("accepted"),
        IN_PROGRESS("in_progress"),
        COMPLETE("complete"),
        FAILED("failed"),
        CANCELED("canceled"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

