/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum OrderLineItemType {
    PRODUCT("Product"),
    FEE("Fee"),
    SERVICES("Services");

    private String value;

    private OrderLineItemType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrderLineItemType fromValue(String value) {
        for (OrderLineItemType b : OrderLineItemType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        OrderLineItemType.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<OrderLineItemType> {
        public void write(JsonWriter jsonWriter, OrderLineItemType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public OrderLineItemType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return OrderLineItemType.fromValue(value);
        }
    }
}

