/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum IndexFileFormat {
    JSON("JSON"),
    CSV("CSV");

    private String value;

    private IndexFileFormat(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IndexFileFormat fromValue(String value) {
        for (IndexFileFormat b : IndexFileFormat.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        IndexFileFormat.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<IndexFileFormat> {
        public void write(JsonWriter jsonWriter, IndexFileFormat enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public IndexFileFormat read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return IndexFileFormat.fromValue(value);
        }
    }
}

