/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.JSON;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.DeploymentResponse;
import com.zuora.model.RetrieveDeploymentResponse;
import com.zuora.model.RevertDeploymentResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class DeploymentApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DeploymentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeploymentApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call compareAndDeployProductCatalogTemplateCall(String name, String description, Boolean sendEmail, File template, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/deployment-manager/deployments/template/product_catalog";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarFormParams.put("name", name);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (sendEmail != null) {
            localVarFormParams.put("sendEmail", sendEmail);
        }
        if (emails != null) {
            localVarFormParams.put("emails", emails);
        }
        if (comments != null) {
            localVarFormParams.put("comments", comments);
        }
        if (template != null) {
            localVarFormParams.put("template", template);
        }
        if (inActiveProducts != null) {
            localVarFormParams.put("inActiveProducts", inActiveProducts);
        }
        if (activeProducts != null) {
            localVarFormParams.put("activeProducts", activeProducts);
        }
        if (activeRatePlans != null) {
            localVarFormParams.put("activeRatePlans", activeRatePlans);
        }
        if (inActiveRatePlans != null) {
            localVarFormParams.put("inActiveRatePlans", inActiveRatePlans);
        }
        if (compareField != null) {
            localVarFormParams.put("compareField", compareField);
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call compareAndDeployProductCatalogTemplateValidateBeforeCall(String name, String description, Boolean sendEmail, File template, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling compareAndDeployProductCatalogTemplate(Async)");
        }
        if (description == null) {
            throw new ApiException("Missing the required parameter 'description' when calling compareAndDeployProductCatalogTemplate(Async)");
        }
        if (sendEmail == null) {
            throw new ApiException("Missing the required parameter 'sendEmail' when calling compareAndDeployProductCatalogTemplate(Async)");
        }
        if (template == null) {
            throw new ApiException("Missing the required parameter 'template' when calling compareAndDeployProductCatalogTemplate(Async)");
        }
        if (inActiveProducts == null) {
            throw new ApiException("Missing the required parameter 'inActiveProducts' when calling compareAndDeployProductCatalogTemplate(Async)");
        }
        if (activeProducts == null) {
            throw new ApiException("Missing the required parameter 'activeProducts' when calling compareAndDeployProductCatalogTemplate(Async)");
        }
        if (activeRatePlans == null) {
            throw new ApiException("Missing the required parameter 'activeRatePlans' when calling compareAndDeployProductCatalogTemplate(Async)");
        }
        if (inActiveRatePlans == null) {
            throw new ApiException("Missing the required parameter 'inActiveRatePlans' when calling compareAndDeployProductCatalogTemplate(Async)");
        }
        if (compareField == null) {
            throw new ApiException("Missing the required parameter 'compareField' when calling compareAndDeployProductCatalogTemplate(Async)");
        }
        return this.compareAndDeployProductCatalogTemplateCall(name, description, sendEmail, template, inActiveProducts, activeProducts, activeRatePlans, inActiveRatePlans, compareField, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, _callback);
    }

    protected DeploymentResponse compareAndDeployProductCatalogTemplate(String name, String description, Boolean sendEmail, File template, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments) throws ApiException {
        ApiResponse<DeploymentResponse> localVarResp = this.compareAndDeployProductCatalogTemplateWithHttpInfo(name, description, sendEmail, template, inActiveProducts, activeProducts, activeRatePlans, inActiveRatePlans, compareField, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments);
        return localVarResp.getData();
    }

    private ApiResponse<DeploymentResponse> compareAndDeployProductCatalogTemplateWithHttpInfo(String name, String description, Boolean sendEmail, File template, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments) throws ApiException {
        Call localVarCall = this.compareAndDeployProductCatalogTemplateValidateBeforeCall(name, description, sendEmail, template, inActiveProducts, activeProducts, activeRatePlans, inActiveRatePlans, compareField, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, null);
        try {
            Type localVarReturnType = new TypeToken<DeploymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call compareAndDeployProductCatalogTemplateAsync(String name, String description, Boolean sendEmail, File template, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, ApiCallback<DeploymentResponse> _callback) throws ApiException {
        Call localVarCall = this.compareAndDeployProductCatalogTemplateValidateBeforeCall(name, description, sendEmail, template, inActiveProducts, activeProducts, activeRatePlans, inActiveRatePlans, compareField, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, _callback);
        Type localVarReturnType = new TypeToken<DeploymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CompareAndDeployProductCatalogTemplateApi compareAndDeployProductCatalogTemplateApi(String name, String description, Boolean sendEmail, File template, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField) {
        return new CompareAndDeployProductCatalogTemplateApi(name, description, sendEmail, template, inActiveProducts, activeProducts, activeRatePlans, inActiveRatePlans, compareField);
    }

    private Call compareAndDeployProductCatalogTenantCall(String name, String description, Boolean sendEmail, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField, String sourceTenantId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/deployment-manager/deployments/tenant/product_catalog";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarFormParams.put("name", name);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (sendEmail != null) {
            localVarFormParams.put("sendEmail", sendEmail);
        }
        if (emails != null) {
            localVarFormParams.put("emails", emails);
        }
        if (comments != null) {
            localVarFormParams.put("comments", comments);
        }
        if (inActiveProducts != null) {
            localVarFormParams.put("inActiveProducts", inActiveProducts);
        }
        if (activeProducts != null) {
            localVarFormParams.put("activeProducts", activeProducts);
        }
        if (activeRatePlans != null) {
            localVarFormParams.put("activeRatePlans", activeRatePlans);
        }
        if (inActiveRatePlans != null) {
            localVarFormParams.put("inActiveRatePlans", inActiveRatePlans);
        }
        if (compareField != null) {
            localVarFormParams.put("compareField", compareField);
        }
        if (sourceTenantId != null) {
            localVarFormParams.put("sourceTenantId", sourceTenantId);
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call compareAndDeployProductCatalogTenantValidateBeforeCall(String name, String description, Boolean sendEmail, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField, String sourceTenantId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling compareAndDeployProductCatalogTenant(Async)");
        }
        if (description == null) {
            throw new ApiException("Missing the required parameter 'description' when calling compareAndDeployProductCatalogTenant(Async)");
        }
        if (sendEmail == null) {
            throw new ApiException("Missing the required parameter 'sendEmail' when calling compareAndDeployProductCatalogTenant(Async)");
        }
        if (inActiveProducts == null) {
            throw new ApiException("Missing the required parameter 'inActiveProducts' when calling compareAndDeployProductCatalogTenant(Async)");
        }
        if (activeProducts == null) {
            throw new ApiException("Missing the required parameter 'activeProducts' when calling compareAndDeployProductCatalogTenant(Async)");
        }
        if (activeRatePlans == null) {
            throw new ApiException("Missing the required parameter 'activeRatePlans' when calling compareAndDeployProductCatalogTenant(Async)");
        }
        if (inActiveRatePlans == null) {
            throw new ApiException("Missing the required parameter 'inActiveRatePlans' when calling compareAndDeployProductCatalogTenant(Async)");
        }
        if (compareField == null) {
            throw new ApiException("Missing the required parameter 'compareField' when calling compareAndDeployProductCatalogTenant(Async)");
        }
        if (sourceTenantId == null) {
            throw new ApiException("Missing the required parameter 'sourceTenantId' when calling compareAndDeployProductCatalogTenant(Async)");
        }
        return this.compareAndDeployProductCatalogTenantCall(name, description, sendEmail, inActiveProducts, activeProducts, activeRatePlans, inActiveRatePlans, compareField, sourceTenantId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, _callback);
    }

    protected DeploymentResponse compareAndDeployProductCatalogTenant(String name, String description, Boolean sendEmail, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField, String sourceTenantId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments) throws ApiException {
        ApiResponse<DeploymentResponse> localVarResp = this.compareAndDeployProductCatalogTenantWithHttpInfo(name, description, sendEmail, inActiveProducts, activeProducts, activeRatePlans, inActiveRatePlans, compareField, sourceTenantId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments);
        return localVarResp.getData();
    }

    private ApiResponse<DeploymentResponse> compareAndDeployProductCatalogTenantWithHttpInfo(String name, String description, Boolean sendEmail, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField, String sourceTenantId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments) throws ApiException {
        Call localVarCall = this.compareAndDeployProductCatalogTenantValidateBeforeCall(name, description, sendEmail, inActiveProducts, activeProducts, activeRatePlans, inActiveRatePlans, compareField, sourceTenantId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, null);
        try {
            Type localVarReturnType = new TypeToken<DeploymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call compareAndDeployProductCatalogTenantAsync(String name, String description, Boolean sendEmail, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField, String sourceTenantId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, ApiCallback<DeploymentResponse> _callback) throws ApiException {
        Call localVarCall = this.compareAndDeployProductCatalogTenantValidateBeforeCall(name, description, sendEmail, inActiveProducts, activeProducts, activeRatePlans, inActiveRatePlans, compareField, sourceTenantId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, _callback);
        Type localVarReturnType = new TypeToken<DeploymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CompareAndDeployProductCatalogTenantApi compareAndDeployProductCatalogTenantApi(String name, String description, Boolean sendEmail, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField, String sourceTenantId) {
        return new CompareAndDeployProductCatalogTenantApi(name, description, sendEmail, inActiveProducts, activeProducts, activeRatePlans, inActiveRatePlans, compareField, sourceTenantId);
    }

    private Call compareAndDeployTemplateCall(String name, String description, Boolean sendEmail, File template, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/deployment-manager/deployments/templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarFormParams.put("name", name);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (sendEmail != null) {
            localVarFormParams.put("sendEmail", sendEmail);
        }
        if (emails != null) {
            localVarFormParams.put("emails", emails);
        }
        if (comments != null) {
            localVarFormParams.put("comments", comments);
        }
        if (template != null) {
            localVarFormParams.put("template", template);
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call compareAndDeployTemplateValidateBeforeCall(String name, String description, Boolean sendEmail, File template, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling compareAndDeployTemplate(Async)");
        }
        if (description == null) {
            throw new ApiException("Missing the required parameter 'description' when calling compareAndDeployTemplate(Async)");
        }
        if (sendEmail == null) {
            throw new ApiException("Missing the required parameter 'sendEmail' when calling compareAndDeployTemplate(Async)");
        }
        if (template == null) {
            throw new ApiException("Missing the required parameter 'template' when calling compareAndDeployTemplate(Async)");
        }
        return this.compareAndDeployTemplateCall(name, description, sendEmail, template, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, _callback);
    }

    protected DeploymentResponse compareAndDeployTemplate(String name, String description, Boolean sendEmail, File template, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments) throws ApiException {
        ApiResponse<DeploymentResponse> localVarResp = this.compareAndDeployTemplateWithHttpInfo(name, description, sendEmail, template, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments);
        return localVarResp.getData();
    }

    private ApiResponse<DeploymentResponse> compareAndDeployTemplateWithHttpInfo(String name, String description, Boolean sendEmail, File template, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments) throws ApiException {
        Call localVarCall = this.compareAndDeployTemplateValidateBeforeCall(name, description, sendEmail, template, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, null);
        try {
            Type localVarReturnType = new TypeToken<DeploymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call compareAndDeployTemplateAsync(String name, String description, Boolean sendEmail, File template, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, ApiCallback<DeploymentResponse> _callback) throws ApiException {
        Call localVarCall = this.compareAndDeployTemplateValidateBeforeCall(name, description, sendEmail, template, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, _callback);
        Type localVarReturnType = new TypeToken<DeploymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CompareAndDeployTemplateApi compareAndDeployTemplateApi(String name, String description, Boolean sendEmail, File template) {
        return new CompareAndDeployTemplateApi(name, description, sendEmail, template);
    }

    private Call compareAndDeployTenantCall(String name, String description, Boolean sendEmail, Boolean settings, Boolean notifications, Boolean workflows, Boolean customFields, Boolean productCatalog, Boolean userRoles, Boolean reporting, String sourceTenantId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, Boolean customObjects, Boolean taxation, Boolean billingDocuments, Boolean customLogic, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/deployment-manager/deployments/tenants";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarFormParams.put("name", name);
        }
        if (description != null) {
            localVarFormParams.put("description", description);
        }
        if (sendEmail != null) {
            localVarFormParams.put("sendEmail", sendEmail);
        }
        if (emails != null) {
            localVarFormParams.put("emails", emails);
        }
        if (comments != null) {
            localVarFormParams.put("comments", comments);
        }
        if (settings != null) {
            localVarFormParams.put("settings", settings);
        }
        if (notifications != null) {
            localVarFormParams.put("notifications", notifications);
        }
        if (workflows != null) {
            localVarFormParams.put("workflows", workflows);
        }
        if (customFields != null) {
            localVarFormParams.put("customFields", customFields);
        }
        if (customObjects != null) {
            localVarFormParams.put("customObjects", customObjects);
        }
        if (productCatalog != null) {
            localVarFormParams.put("productCatalog", productCatalog);
        }
        if (taxation != null) {
            localVarFormParams.put("taxation", taxation);
        }
        if (userRoles != null) {
            localVarFormParams.put("userRoles", userRoles);
        }
        if (reporting != null) {
            localVarFormParams.put("reporting", reporting);
        }
        if (billingDocuments != null) {
            localVarFormParams.put("billingDocuments", billingDocuments);
        }
        if (customLogic != null) {
            localVarFormParams.put("customLogic", customLogic);
        }
        if (sourceTenantId != null) {
            localVarFormParams.put("sourceTenantId", sourceTenantId);
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call compareAndDeployTenantValidateBeforeCall(String name, String description, Boolean sendEmail, Boolean settings, Boolean notifications, Boolean workflows, Boolean customFields, Boolean productCatalog, Boolean userRoles, Boolean reporting, String sourceTenantId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, Boolean customObjects, Boolean taxation, Boolean billingDocuments, Boolean customLogic, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling compareAndDeployTenant(Async)");
        }
        if (description == null) {
            throw new ApiException("Missing the required parameter 'description' when calling compareAndDeployTenant(Async)");
        }
        if (sendEmail == null) {
            throw new ApiException("Missing the required parameter 'sendEmail' when calling compareAndDeployTenant(Async)");
        }
        if (settings == null) {
            throw new ApiException("Missing the required parameter 'settings' when calling compareAndDeployTenant(Async)");
        }
        if (notifications == null) {
            throw new ApiException("Missing the required parameter 'notifications' when calling compareAndDeployTenant(Async)");
        }
        if (workflows == null) {
            throw new ApiException("Missing the required parameter 'workflows' when calling compareAndDeployTenant(Async)");
        }
        if (customFields == null) {
            throw new ApiException("Missing the required parameter 'customFields' when calling compareAndDeployTenant(Async)");
        }
        if (productCatalog == null) {
            throw new ApiException("Missing the required parameter 'productCatalog' when calling compareAndDeployTenant(Async)");
        }
        if (userRoles == null) {
            throw new ApiException("Missing the required parameter 'userRoles' when calling compareAndDeployTenant(Async)");
        }
        if (reporting == null) {
            throw new ApiException("Missing the required parameter 'reporting' when calling compareAndDeployTenant(Async)");
        }
        if (sourceTenantId == null) {
            throw new ApiException("Missing the required parameter 'sourceTenantId' when calling compareAndDeployTenant(Async)");
        }
        return this.compareAndDeployTenantCall(name, description, sendEmail, settings, notifications, workflows, customFields, productCatalog, userRoles, reporting, sourceTenantId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, customObjects, taxation, billingDocuments, customLogic, _callback);
    }

    protected DeploymentResponse compareAndDeployTenant(String name, String description, Boolean sendEmail, Boolean settings, Boolean notifications, Boolean workflows, Boolean customFields, Boolean productCatalog, Boolean userRoles, Boolean reporting, String sourceTenantId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, Boolean customObjects, Boolean taxation, Boolean billingDocuments, Boolean customLogic) throws ApiException {
        ApiResponse<DeploymentResponse> localVarResp = this.compareAndDeployTenantWithHttpInfo(name, description, sendEmail, settings, notifications, workflows, customFields, productCatalog, userRoles, reporting, sourceTenantId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, customObjects, taxation, billingDocuments, customLogic);
        return localVarResp.getData();
    }

    private ApiResponse<DeploymentResponse> compareAndDeployTenantWithHttpInfo(String name, String description, Boolean sendEmail, Boolean settings, Boolean notifications, Boolean workflows, Boolean customFields, Boolean productCatalog, Boolean userRoles, Boolean reporting, String sourceTenantId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, Boolean customObjects, Boolean taxation, Boolean billingDocuments, Boolean customLogic) throws ApiException {
        Call localVarCall = this.compareAndDeployTenantValidateBeforeCall(name, description, sendEmail, settings, notifications, workflows, customFields, productCatalog, userRoles, reporting, sourceTenantId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, customObjects, taxation, billingDocuments, customLogic, null);
        try {
            Type localVarReturnType = new TypeToken<DeploymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call compareAndDeployTenantAsync(String name, String description, Boolean sendEmail, Boolean settings, Boolean notifications, Boolean workflows, Boolean customFields, Boolean productCatalog, Boolean userRoles, Boolean reporting, String sourceTenantId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String emails, String comments, Boolean customObjects, Boolean taxation, Boolean billingDocuments, Boolean customLogic, ApiCallback<DeploymentResponse> _callback) throws ApiException {
        Call localVarCall = this.compareAndDeployTenantValidateBeforeCall(name, description, sendEmail, settings, notifications, workflows, customFields, productCatalog, userRoles, reporting, sourceTenantId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, emails, comments, customObjects, taxation, billingDocuments, customLogic, _callback);
        Type localVarReturnType = new TypeToken<DeploymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CompareAndDeployTenantApi compareAndDeployTenantApi(String name, String description, Boolean sendEmail, Boolean settings, Boolean notifications, Boolean workflows, Boolean customFields, Boolean productCatalog, Boolean userRoles, Boolean reporting, String sourceTenantId) {
        return new CompareAndDeployTenantApi(name, description, sendEmail, settings, notifications, workflows, customFields, productCatalog, userRoles, reporting, sourceTenantId);
    }

    private Call retrieveDeploymentCall(String migrationId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/deployment-manager/deployments/{migrationId}".replace("{migrationId}", this.localVarApiClient.escapeString(migrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call retrieveDeploymentValidateBeforeCall(String migrationId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, ApiCallback _callback) throws ApiException {
        if (migrationId == null) {
            throw new ApiException("Missing the required parameter 'migrationId' when calling retrieveDeployment(Async)");
        }
        return this.retrieveDeploymentCall(migrationId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, _callback);
    }

    protected RetrieveDeploymentResponse retrieveDeployment(String migrationId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds) throws ApiException {
        ApiResponse<RetrieveDeploymentResponse> localVarResp = this.retrieveDeploymentWithHttpInfo(migrationId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds);
        return localVarResp.getData();
    }

    private ApiResponse<RetrieveDeploymentResponse> retrieveDeploymentWithHttpInfo(String migrationId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds) throws ApiException {
        Call localVarCall = this.retrieveDeploymentValidateBeforeCall(migrationId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, null);
        try {
            Type localVarReturnType = new TypeToken<RetrieveDeploymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call retrieveDeploymentAsync(String migrationId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, ApiCallback<RetrieveDeploymentResponse> _callback) throws ApiException {
        Call localVarCall = this.retrieveDeploymentValidateBeforeCall(migrationId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, _callback);
        Type localVarReturnType = new TypeToken<RetrieveDeploymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public RetrieveDeploymentApi retrieveDeploymentApi(String migrationId) {
        return new RetrieveDeploymentApi(migrationId);
    }

    private Call revertDeploymentCall(String migrationId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/deployment-manager/deployments/{migrationId}/revert".replace("{migrationId}", this.localVarApiClient.escapeString(migrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revertDeploymentValidateBeforeCall(String migrationId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, ApiCallback _callback) throws ApiException {
        if (migrationId == null) {
            throw new ApiException("Missing the required parameter 'migrationId' when calling revertDeployment(Async)");
        }
        return this.revertDeploymentCall(migrationId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, _callback);
    }

    protected RevertDeploymentResponse revertDeployment(String migrationId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds) throws ApiException {
        ApiResponse<RevertDeploymentResponse> localVarResp = this.revertDeploymentWithHttpInfo(migrationId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds);
        return localVarResp.getData();
    }

    private ApiResponse<RevertDeploymentResponse> revertDeploymentWithHttpInfo(String migrationId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds) throws ApiException {
        Call localVarCall = this.revertDeploymentValidateBeforeCall(migrationId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, null);
        try {
            Type localVarReturnType = new TypeToken<RevertDeploymentResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            this.localVarApiClient.getJSON();
            e.setErrorObject((CommonResponse)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<CommonResponse>(){}.getType()));
            throw e;
        }
    }

    private Call revertDeploymentAsync(String migrationId, String zuoraVersion, String zuoraOrgIds, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, ApiCallback<RevertDeploymentResponse> _callback) throws ApiException {
        Call localVarCall = this.revertDeploymentValidateBeforeCall(migrationId, zuoraVersion, zuoraOrgIds, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, _callback);
        Type localVarReturnType = new TypeToken<RevertDeploymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public RevertDeploymentApi revertDeploymentApi(String migrationId) {
        return new RevertDeploymentApi(migrationId);
    }

    public class RevertDeploymentApi {
        private final String migrationId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;

        private RevertDeploymentApi(String migrationId) {
            this.migrationId = migrationId;
        }

        public RevertDeploymentApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public RevertDeploymentApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public RevertDeploymentApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public RevertDeploymentApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public RevertDeploymentApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public RevertDeploymentApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public RevertDeploymentApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeploymentApi.this.revertDeploymentCall(this.migrationId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, _callback);
        }

        public RevertDeploymentResponse execute() throws ApiException {
            ApiResponse<RevertDeploymentResponse> localVarResp = DeploymentApi.this.revertDeploymentWithHttpInfo(this.migrationId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds);
            return localVarResp.getData();
        }

        public ApiResponse<RevertDeploymentResponse> executeWithHttpInfo() throws ApiException {
            return DeploymentApi.this.revertDeploymentWithHttpInfo(this.migrationId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds);
        }

        public Call executeAsync(ApiCallback<RevertDeploymentResponse> _callback) throws ApiException {
            return DeploymentApi.this.revertDeploymentAsync(this.migrationId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, _callback);
        }
    }

    public class RetrieveDeploymentApi {
        private final String migrationId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;

        private RetrieveDeploymentApi(String migrationId) {
            this.migrationId = migrationId;
        }

        public RetrieveDeploymentApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public RetrieveDeploymentApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public RetrieveDeploymentApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public RetrieveDeploymentApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public RetrieveDeploymentApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public RetrieveDeploymentApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public RetrieveDeploymentApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeploymentApi.this.retrieveDeploymentCall(this.migrationId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, _callback);
        }

        public RetrieveDeploymentResponse execute() throws ApiException {
            ApiResponse<RetrieveDeploymentResponse> localVarResp = DeploymentApi.this.retrieveDeploymentWithHttpInfo(this.migrationId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds);
            return localVarResp.getData();
        }

        public ApiResponse<RetrieveDeploymentResponse> executeWithHttpInfo() throws ApiException {
            return DeploymentApi.this.retrieveDeploymentWithHttpInfo(this.migrationId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds);
        }

        public Call executeAsync(ApiCallback<RetrieveDeploymentResponse> _callback) throws ApiException {
            return DeploymentApi.this.retrieveDeploymentAsync(this.migrationId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, _callback);
        }
    }

    public class CompareAndDeployTenantApi {
        private final String name;
        private final String description;
        private final Boolean sendEmail;
        private final Boolean settings;
        private final Boolean notifications;
        private final Boolean workflows;
        private final Boolean customFields;
        private final Boolean productCatalog;
        private final Boolean userRoles;
        private final Boolean reporting;
        private final String sourceTenantId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String emails;
        private String comments;
        private Boolean customObjects;
        private Boolean taxation;
        private Boolean billingDocuments;
        private Boolean customLogic;

        private CompareAndDeployTenantApi(String name, String description, Boolean sendEmail, Boolean settings, Boolean notifications, Boolean workflows, Boolean customFields, Boolean productCatalog, Boolean userRoles, Boolean reporting, String sourceTenantId) {
            this.name = name;
            this.description = description;
            this.sendEmail = sendEmail;
            this.settings = settings;
            this.notifications = notifications;
            this.workflows = workflows;
            this.customFields = customFields;
            this.productCatalog = productCatalog;
            this.userRoles = userRoles;
            this.reporting = reporting;
            this.sourceTenantId = sourceTenantId;
        }

        public CompareAndDeployTenantApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CompareAndDeployTenantApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public CompareAndDeployTenantApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CompareAndDeployTenantApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CompareAndDeployTenantApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CompareAndDeployTenantApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CompareAndDeployTenantApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CompareAndDeployTenantApi emails(String emails) {
            this.emails = emails;
            return this;
        }

        public CompareAndDeployTenantApi comments(String comments) {
            this.comments = comments;
            return this;
        }

        public CompareAndDeployTenantApi customObjects(Boolean customObjects) {
            this.customObjects = customObjects;
            return this;
        }

        public CompareAndDeployTenantApi taxation(Boolean taxation) {
            this.taxation = taxation;
            return this;
        }

        public CompareAndDeployTenantApi billingDocuments(Boolean billingDocuments) {
            this.billingDocuments = billingDocuments;
            return this;
        }

        public CompareAndDeployTenantApi customLogic(Boolean customLogic) {
            this.customLogic = customLogic;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeploymentApi.this.compareAndDeployTenantCall(this.name, this.description, this.sendEmail, this.settings, this.notifications, this.workflows, this.customFields, this.productCatalog, this.userRoles, this.reporting, this.sourceTenantId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments, this.customObjects, this.taxation, this.billingDocuments, this.customLogic, _callback);
        }

        public DeploymentResponse execute() throws ApiException {
            ApiResponse<DeploymentResponse> localVarResp = DeploymentApi.this.compareAndDeployTenantWithHttpInfo(this.name, this.description, this.sendEmail, this.settings, this.notifications, this.workflows, this.customFields, this.productCatalog, this.userRoles, this.reporting, this.sourceTenantId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments, this.customObjects, this.taxation, this.billingDocuments, this.customLogic);
            return localVarResp.getData();
        }

        public ApiResponse<DeploymentResponse> executeWithHttpInfo() throws ApiException {
            return DeploymentApi.this.compareAndDeployTenantWithHttpInfo(this.name, this.description, this.sendEmail, this.settings, this.notifications, this.workflows, this.customFields, this.productCatalog, this.userRoles, this.reporting, this.sourceTenantId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments, this.customObjects, this.taxation, this.billingDocuments, this.customLogic);
        }

        public Call executeAsync(ApiCallback<DeploymentResponse> _callback) throws ApiException {
            return DeploymentApi.this.compareAndDeployTenantAsync(this.name, this.description, this.sendEmail, this.settings, this.notifications, this.workflows, this.customFields, this.productCatalog, this.userRoles, this.reporting, this.sourceTenantId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments, this.customObjects, this.taxation, this.billingDocuments, this.customLogic, _callback);
        }
    }

    public class CompareAndDeployTemplateApi {
        private final String name;
        private final String description;
        private final Boolean sendEmail;
        private final File template;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String emails;
        private String comments;

        private CompareAndDeployTemplateApi(String name, String description, Boolean sendEmail, File template) {
            this.name = name;
            this.description = description;
            this.sendEmail = sendEmail;
            this.template = template;
        }

        public CompareAndDeployTemplateApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CompareAndDeployTemplateApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public CompareAndDeployTemplateApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CompareAndDeployTemplateApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CompareAndDeployTemplateApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CompareAndDeployTemplateApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CompareAndDeployTemplateApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CompareAndDeployTemplateApi emails(String emails) {
            this.emails = emails;
            return this;
        }

        public CompareAndDeployTemplateApi comments(String comments) {
            this.comments = comments;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeploymentApi.this.compareAndDeployTemplateCall(this.name, this.description, this.sendEmail, this.template, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments, _callback);
        }

        public DeploymentResponse execute() throws ApiException {
            ApiResponse<DeploymentResponse> localVarResp = DeploymentApi.this.compareAndDeployTemplateWithHttpInfo(this.name, this.description, this.sendEmail, this.template, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments);
            return localVarResp.getData();
        }

        public ApiResponse<DeploymentResponse> executeWithHttpInfo() throws ApiException {
            return DeploymentApi.this.compareAndDeployTemplateWithHttpInfo(this.name, this.description, this.sendEmail, this.template, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments);
        }

        public Call executeAsync(ApiCallback<DeploymentResponse> _callback) throws ApiException {
            return DeploymentApi.this.compareAndDeployTemplateAsync(this.name, this.description, this.sendEmail, this.template, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments, _callback);
        }
    }

    public class CompareAndDeployProductCatalogTenantApi {
        private final String name;
        private final String description;
        private final Boolean sendEmail;
        private final Boolean inActiveProducts;
        private final Boolean activeProducts;
        private final Boolean activeRatePlans;
        private final Boolean inActiveRatePlans;
        private final String compareField;
        private final String sourceTenantId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String emails;
        private String comments;

        private CompareAndDeployProductCatalogTenantApi(String name, String description, Boolean sendEmail, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField, String sourceTenantId) {
            this.name = name;
            this.description = description;
            this.sendEmail = sendEmail;
            this.inActiveProducts = inActiveProducts;
            this.activeProducts = activeProducts;
            this.activeRatePlans = activeRatePlans;
            this.inActiveRatePlans = inActiveRatePlans;
            this.compareField = compareField;
            this.sourceTenantId = sourceTenantId;
        }

        public CompareAndDeployProductCatalogTenantApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CompareAndDeployProductCatalogTenantApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public CompareAndDeployProductCatalogTenantApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CompareAndDeployProductCatalogTenantApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CompareAndDeployProductCatalogTenantApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CompareAndDeployProductCatalogTenantApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CompareAndDeployProductCatalogTenantApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CompareAndDeployProductCatalogTenantApi emails(String emails) {
            this.emails = emails;
            return this;
        }

        public CompareAndDeployProductCatalogTenantApi comments(String comments) {
            this.comments = comments;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeploymentApi.this.compareAndDeployProductCatalogTenantCall(this.name, this.description, this.sendEmail, this.inActiveProducts, this.activeProducts, this.activeRatePlans, this.inActiveRatePlans, this.compareField, this.sourceTenantId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments, _callback);
        }

        public DeploymentResponse execute() throws ApiException {
            ApiResponse<DeploymentResponse> localVarResp = DeploymentApi.this.compareAndDeployProductCatalogTenantWithHttpInfo(this.name, this.description, this.sendEmail, this.inActiveProducts, this.activeProducts, this.activeRatePlans, this.inActiveRatePlans, this.compareField, this.sourceTenantId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments);
            return localVarResp.getData();
        }

        public ApiResponse<DeploymentResponse> executeWithHttpInfo() throws ApiException {
            return DeploymentApi.this.compareAndDeployProductCatalogTenantWithHttpInfo(this.name, this.description, this.sendEmail, this.inActiveProducts, this.activeProducts, this.activeRatePlans, this.inActiveRatePlans, this.compareField, this.sourceTenantId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments);
        }

        public Call executeAsync(ApiCallback<DeploymentResponse> _callback) throws ApiException {
            return DeploymentApi.this.compareAndDeployProductCatalogTenantAsync(this.name, this.description, this.sendEmail, this.inActiveProducts, this.activeProducts, this.activeRatePlans, this.inActiveRatePlans, this.compareField, this.sourceTenantId, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments, _callback);
        }
    }

    public class CompareAndDeployProductCatalogTemplateApi {
        private final String name;
        private final String description;
        private final Boolean sendEmail;
        private final File template;
        private final Boolean inActiveProducts;
        private final Boolean activeProducts;
        private final Boolean activeRatePlans;
        private final Boolean inActiveRatePlans;
        private final String compareField;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String emails;
        private String comments;

        private CompareAndDeployProductCatalogTemplateApi(String name, String description, Boolean sendEmail, File template, Boolean inActiveProducts, Boolean activeProducts, Boolean activeRatePlans, Boolean inActiveRatePlans, String compareField) {
            this.name = name;
            this.description = description;
            this.sendEmail = sendEmail;
            this.template = template;
            this.inActiveProducts = inActiveProducts;
            this.activeProducts = activeProducts;
            this.activeRatePlans = activeRatePlans;
            this.inActiveRatePlans = inActiveRatePlans;
            this.compareField = compareField;
        }

        public CompareAndDeployProductCatalogTemplateApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CompareAndDeployProductCatalogTemplateApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public CompareAndDeployProductCatalogTemplateApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CompareAndDeployProductCatalogTemplateApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CompareAndDeployProductCatalogTemplateApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CompareAndDeployProductCatalogTemplateApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CompareAndDeployProductCatalogTemplateApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CompareAndDeployProductCatalogTemplateApi emails(String emails) {
            this.emails = emails;
            return this;
        }

        public CompareAndDeployProductCatalogTemplateApi comments(String comments) {
            this.comments = comments;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeploymentApi.this.compareAndDeployProductCatalogTemplateCall(this.name, this.description, this.sendEmail, this.template, this.inActiveProducts, this.activeProducts, this.activeRatePlans, this.inActiveRatePlans, this.compareField, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments, _callback);
        }

        public DeploymentResponse execute() throws ApiException {
            ApiResponse<DeploymentResponse> localVarResp = DeploymentApi.this.compareAndDeployProductCatalogTemplateWithHttpInfo(this.name, this.description, this.sendEmail, this.template, this.inActiveProducts, this.activeProducts, this.activeRatePlans, this.inActiveRatePlans, this.compareField, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments);
            return localVarResp.getData();
        }

        public ApiResponse<DeploymentResponse> executeWithHttpInfo() throws ApiException {
            return DeploymentApi.this.compareAndDeployProductCatalogTemplateWithHttpInfo(this.name, this.description, this.sendEmail, this.template, this.inActiveProducts, this.activeProducts, this.activeRatePlans, this.inActiveRatePlans, this.compareField, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments);
        }

        public Call executeAsync(ApiCallback<DeploymentResponse> _callback) throws ApiException {
            return DeploymentApi.this.compareAndDeployProductCatalogTemplateAsync(this.name, this.description, this.sendEmail, this.template, this.inActiveProducts, this.activeProducts, this.activeRatePlans, this.inActiveRatePlans, this.compareField, this.zuoraVersion, this.zuoraOrgIds, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.emails, this.comments, _callback);
        }
    }
}

