/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Tiers information of the billing document items.")
public class ItemTier {
    public static final String SERIALIZED_NAME_UP_TO = "up_to";
    @SerializedName(value="up_to")
    private BigDecimal upTo;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_UNIT_AMOUNT = "unit_amount";
    @SerializedName(value="unit_amount")
    private BigDecimal unitAmount;

    public ItemTier upTo(BigDecimal upTo) {
        this.upTo = upTo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the upper bound of the tier. The lower bound of a tier is the upper bound of the previous tier plus one.")
    public BigDecimal getUpTo() {
        return this.upTo;
    }

    public void setUpTo(BigDecimal upTo) {
        this.upTo = upTo;
    }

    public ItemTier amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the price. Specify this field if you want to override the original price with a flat-fee price.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public ItemTier unitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unit amount of the price. Specify this field if you want to override the original price with a per-unit price.")
    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemTier itemTier = (ItemTier)o;
        return Objects.equals(this.upTo, itemTier.upTo) && Objects.equals(this.amount, itemTier.amount) && Objects.equals(this.unitAmount, itemTier.unitAmount);
    }

    public int hashCode() {
        return Objects.hash(this.upTo, this.amount, this.unitAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemTier {\n");
        sb.append("    upTo: ").append(this.toIndentedString(this.upTo)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    unitAmount: ").append(this.toIndentedString(this.unitAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

