/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The file object representing the results of the query.")
public class QueryRunFile {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "content_type";
    @SerializedName(value="content_type")
    private ContentTypeEnum contentType;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;

    public QueryRunFile() {
    }

    public QueryRunFile(String id) {
        this();
        this.id = id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    public QueryRunFile url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL from which the file can be downloaded")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public QueryRunFile contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the file returned.")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public QueryRunFile type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of file.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRunFile queryRunFile = (QueryRunFile)o;
        return Objects.equals(this.id, queryRunFile.id) && Objects.equals(this.url, queryRunFile.url) && Objects.equals((Object)this.contentType, (Object)queryRunFile.contentType) && Objects.equals((Object)this.type, (Object)queryRunFile.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.url, this.contentType, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryRunFile {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        QUERY_RUN("query_run"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContentTypeEnum {
        JSON("json"),
        JSONL("jsonl"),
        CSV("csv"),
        TSV("tsv"),
        DSV("dsv"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContentTypeEnum fromValue(String value) {
            for (ContentTypeEnum b : ContentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ContentTypeEnum> {
            public void write(JsonWriter jsonWriter, ContentTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ContentTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContentTypeEnum.fromValue(value);
            }
        }
    }
}

